/*
 * Decompiled with CFR 0.152.
 */
package gui.lsystem;

import grammar.lsystem.Expander;
import grammar.lsystem.LSystem;
import gui.ImageDisplayComponent;
import gui.lsystem.LSystemInputPane;
import gui.lsystem.Renderer;
import gui.transform.Matrix;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DisplayPane
extends JPanel {
    private LSystem lsystem;
    private Expander expander = null;
    private Renderer renderer = new Renderer();
    private ImageDisplayComponent imageDisplay = new ImageDisplayComponent();
    private SpinnerNumberModel spinnerModel = new SpinnerNumberModel(0, 0, 200, 1);
    private JTextField expansionDisplay = new JTextField();
    private JProgressBar progressBar = new JProgressBar(0, 1);
    private Action displayAction = new AbstractAction("Redisplay"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DisplayPane.this.updateDisplay();
            DisplayPane.this.displayAction.setEnabled(false);
        }
    };
    private SpinnerNumberModel pitchModel = new SpinnerNumberModel(0, 0, 359, 15);
    private SpinnerNumberModel rollModel = new SpinnerNumberModel(0, 0, 359, 15);
    private SpinnerNumberModel yawModel = new SpinnerNumberModel(0, 0, 359, 15);

    public DisplayPane(LSystem lSystem) {
        super(new BorderLayout());
        this.lsystem = lSystem;
        this.expander = new Expander(lSystem);
        this.expansionDisplay.setEditable(false);
        JSpinner jSpinner = new JSpinner(this.spinnerModel);
        this.spinnerModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                DisplayPane.this.updateDisplay();
            }
        });
        JSpinner jSpinner2 = new JSpinner(this.pitchModel);
        JSpinner jSpinner3 = new JSpinner(this.rollModel);
        JSpinner jSpinner4 = new JSpinner(this.yawModel);
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                DisplayPane.this.updateDisplay();
            }
        };
        this.pitchModel.addChangeListener(changeListener);
        this.rollModel.addChangeListener(changeListener);
        this.yawModel.addChangeListener(changeListener);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jSpinner, "East");
        jPanel.add((Component)this.expansionDisplay, "Center");
        jPanel.add((Component)this.progressBar, "West");
        this.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel();
        jPanel2.add(new JLabel("Pitch"));
        jPanel2.add(jSpinner2);
        jPanel2.add(new JLabel("Roll"));
        jPanel2.add(jSpinner3);
        jPanel2.add(new JLabel("Yaw"));
        jPanel2.add(jSpinner4);
        JScrollPane jScrollPane = new JScrollPane(this.imageDisplay);
        this.add((Component)jScrollPane, "Center");
        this.add((Component)jPanel2, "South");
        this.updateDisplay();
    }

    private void updateDisplay() {
        int n = this.spinnerModel.getNumber().intValue();
        final List list = this.expander.expansionForLevel(n);
        this.progressBar.setMaximum(list.size() * 2);
        this.imageDisplay.setImage(null);
        Object var3_3 = null;
        final Timer timer = new Timer(30, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = DisplayPane.this.renderer.getDoneSymbols() - 1;
                DisplayPane.this.progressBar.setValue(n);
                DisplayPane.this.progressBar.repaint();
            }
        });
        Thread thread = new Thread(){

            @Override
            public void run() {
                Object object;
                if (list.size() < 70) {
                    object = LSystemInputPane.listAsString(list);
                    DisplayPane.this.expansionDisplay.setText((String)object);
                } else {
                    DisplayPane.this.expansionDisplay.setText("Suffice to say, quite long.");
                }
                object = DisplayPane.this.lsystem.getValues();
                timer.start();
                Matrix matrix = new Matrix();
                double d = DisplayPane.this.pitchModel.getNumber().doubleValue();
                double d2 = DisplayPane.this.rollModel.getNumber().doubleValue();
                double d3 = DisplayPane.this.yawModel.getNumber().doubleValue();
                matrix.pitch(d);
                matrix.roll(d2);
                matrix.yaw(d3);
                Point point = new Point();
                Image image = DisplayPane.this.renderer.render(list, (Map)object, matrix, null, point);
                DisplayPane.this.imageDisplay.setImage(image);
                timer.stop();
                DisplayPane.this.imageDisplay.repaint();
                DisplayPane.this.imageDisplay.revalidate();
                DisplayPane.this.progressBar.setValue(DisplayPane.this.progressBar.getMaximum());
            }
        };
        thread.start();
    }

    @Override
    public void printComponent(Graphics graphics) {
        int n = this.spinnerModel.getNumber().intValue();
        List list = this.expander.expansionForLevel(n);
        Map map = this.lsystem.getValues();
        Matrix matrix = new Matrix();
        double d = this.pitchModel.getNumber().doubleValue();
        double d2 = this.rollModel.getNumber().doubleValue();
        double d3 = this.yawModel.getNumber().doubleValue();
        matrix.pitch(d);
        matrix.roll(d2);
        matrix.yaw(d3);
        this.renderer.render(list, map, matrix, (Graphics2D)graphics, new Point());
    }

    @Override
    public void printChildren(Graphics graphics) {
    }
}

