/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar.transform;

import automata.State;
import automata.Transition;
import automata.event.AutomataTransitionEvent;
import automata.event.AutomataTransitionListener;
import automata.vdg.VariableDependencyGraph;
import grammar.Grammar;
import grammar.Production;
import grammar.UselessProductionRemover;
import gui.grammar.transform.UselessPane;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JOptionPane;

public class UselessController {
    UselessPane pane;
    Grammar grammar;
    UselessProductionRemover remover = new UselessProductionRemover();
    Set terminalVariables;
    Set derivedTerminalVariables = new TreeSet();
    VariableDependencyGraph vdg = new VariableDependencyGraph();
    Set vdgTransitions = new HashSet();
    Set currentProductions = new HashSet();
    Set uselessProductions = new HashSet();
    int step = 0;
    static final int DERIVE_TERMINALS = 1;
    static final int VARAIBLE_GRAPH = 2;
    static final int PRODUCTION_MODIFY = 3;
    static final int FINISHED = 4;
    static final int START_NOT_TERMINAL_DERIVING_ERROR = 5;

    public UselessController(UselessPane uselessPane, Grammar grammar) {
        this.pane = uselessPane;
        this.grammar = grammar;
        this.nextStep();
    }

    private void nextStep() {
        if (this.step < 4) {
            ++this.step;
        }
        switch (this.step) {
            case 1: {
                this.pane.mainLabel.setText("Select variables that derive terminals.");
                this.pane.detailLabel.setText("Click productions; the LHS variable will be added.");
                this.terminalVariables = UselessProductionRemover.getCompleteUsefulVariableSet(this.grammar);
                this.pane.deleteAction.setEnabled(false);
                this.pane.doStepAction.setEnabled(true);
                this.pane.doAllAction.setEnabled(true);
                this.pane.proceedAction.setEnabled(false);
                this.pane.exportAction.setEnabled(false);
                this.grammar = UselessProductionRemover.getTerminalGrammar(this.grammar);
                break;
            }
            case 2: {
                int n;
                if (!this.terminalVariables.contains(this.grammar.getStartVariable())) {
                    this.step = 5;
                    this.nextStep();
                    return;
                }
                this.pane.mainLabel.setText("Complete dependency graph.");
                this.pane.detailLabel.setText("For every production, connect start and end.");
                UselessProductionRemover.initializeVariableDependencyGraph(this.vdg, this.grammar);
                State[] stateArray = this.vdg.getStates();
                for (int i = 0; i < stateArray.length; ++i) {
                    if (!this.terminalVariables.contains(stateArray[i].getName())) continue;
                    this.vdg.addFinalState(stateArray[i]);
                }
                Production[] productionArray = this.grammar.getProductions();
                String[] stringArray = this.terminalVariables.toArray(new String[0]);
                for (n = 0; n < stringArray.length; ++n) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        String string = stringArray[n];
                        String string2 = stringArray[i];
                        if (n == i || !UselessProductionRemover.isDependentOn(string, string2, this.grammar)) continue;
                        this.vdgTransitions.add(UselessProductionRemover.getTransition(string, string2, this.vdg));
                    }
                }
                this.vdg.addTransitionListener(new AutomataTransitionListener(){

                    @Override
                    public void automataTransitionChange(AutomataTransitionEvent automataTransitionEvent) {
                        if (!automataTransitionEvent.isAdd()) {
                            return;
                        }
                        if (UselessController.this.vdgTransitions.contains(automataTransitionEvent.getTransition())) {
                            UselessController.this.vdgTransitions.remove(automataTransitionEvent.getTransition());
                            UselessController.this.updateDisplay();
                            return;
                        }
                        JOptionPane.showMessageDialog(UselessController.this.pane, "Transition is not part of VDG.", "Bad Transition", 0);
                        UselessController.this.vdg.removeTransition(automataTransitionEvent.getTransition());
                    }
                });
                for (n = 0; n < productionArray.length; ++n) {
                    this.pane.editingGrammarModel.addProduction(productionArray[n]);
                    this.currentProductions.add(productionArray[n]);
                }
                this.updateDisplay();
                break;
            }
            case 3: {
                this.pane.updateDeleteEnabledness();
                this.pane.mainLabel.setText("Modify the grammar to remove useless productions.");
                Grammar grammar = UselessProductionRemover.getUselessProductionlessGrammar(this.grammar);
                Production[] productionArray = this.grammar.getProductions();
                Production[] productionArray2 = grammar.getProductions();
                HashSet<Production> hashSet = new HashSet<Production>(Arrays.asList(productionArray2));
                for (int i = 0; i < productionArray.length; ++i) {
                    if (hashSet.contains(productionArray[i])) continue;
                    this.uselessProductions.add(productionArray[i]);
                }
                this.updateDisplay();
                break;
            }
            case 4: {
                this.pane.editingActive = false;
                this.pane.deleteAction.setEnabled(false);
                this.pane.mainLabel.setText("Useless removal complete.");
                this.pane.detailLabel.setText("\"Proceed\" or \"Export\" available.");
                this.pane.doStepAction.setEnabled(false);
                this.pane.doAllAction.setEnabled(false);
                this.pane.proceedAction.setEnabled(true);
                this.pane.exportAction.setEnabled(true);
                break;
            }
            case 5: {
                this.pane.mainLabel.setText("The start variable " + this.grammar.getStartVariable() + " does not derive terminals.");
                this.pane.detailLabel.setText("The grammar cannot have rules.  No further action is sensible.");
                this.pane.doStepAction.setEnabled(false);
                this.pane.doAllAction.setEnabled(false);
                this.pane.proceedAction.setEnabled(false);
                this.pane.exportAction.setEnabled(false);
            }
        }
    }

    void doStep() {
        switch (this.step) {
            case 1: {
                this.derivedTerminalVariables.addAll(this.terminalVariables);
                this.pane.terminalLabel.setText("Variables that predicate terminals: " + this.derivedTerminalVariables);
                this.nextStep();
                break;
            }
            case 2: {
                Transition[] transitionArray = this.vdgTransitions.toArray(new Transition[0]);
                for (int i = 0; i < transitionArray.length; ++i) {
                    this.vdg.addTransition(transitionArray[i]);
                }
                break;
            }
            case 3: {
                for (int i = this.pane.editingGrammarModel.getRowCount() - 2; i >= 0; --i) {
                    Production production = this.pane.editingGrammarModel.getProduction(i);
                    if (!this.uselessProductions.contains(production)) continue;
                    this.pane.editingGrammarModel.deleteRow(i);
                    this.uselessProductions.remove(production);
                }
                this.updateDisplay();
                break;
            }
        }
    }

    public void doAll() {
        while (this.step != 4) {
            this.doStep();
        }
    }

    public Grammar getGrammar() {
        return this.pane.getGrammar();
    }

    void updateDisplay() {
        switch (this.step) {
            case 2: {
                int n = this.vdgTransitions.size();
                this.pane.detailLabel.setText(n + " more transition(s) needed.");
                if (n != 0) break;
                this.nextStep();
                break;
            }
            case 3: {
                int n = this.uselessProductions.size();
                this.pane.detailLabel.setText(n + " more remove(s) needed.");
                if (n != 0) break;
                this.nextStep();
                break;
            }
        }
    }

    void productionClicked(Production production, MouseEvent mouseEvent) {
        switch (this.step) {
            case 1: {
                String string = production.getLHS();
                if (this.derivedTerminalVariables.contains(string)) {
                    this.pane.detailLabel.setText(string + " already selected!  " + (this.terminalVariables.size() - this.derivedTerminalVariables.size()) + " more variable(s) needed.");
                    return;
                }
                if (this.terminalVariables.contains(string)) {
                    this.derivedTerminalVariables.add(string);
                    this.pane.detailLabel.setText(string + " added!  " + (this.terminalVariables.size() - this.derivedTerminalVariables.size()) + " more variable(s) needed.");
                    this.pane.terminalLabel.setText("Variables that predicate terminals: " + this.derivedTerminalVariables);
                    if (this.derivedTerminalVariables.size() == this.terminalVariables.size()) {
                        this.nextStep();
                    }
                    return;
                }
                this.pane.detailLabel.setText(string + " does not predicate terminals!  " + (this.terminalVariables.size() - this.derivedTerminalVariables.size()) + " more variable(s) needed.");
                break;
            }
        }
    }

    boolean productionDeleted(Production production, int n) {
        return this.uselessProductions.remove(production) && this.currentProductions.remove(production);
    }
}

