/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar.transform;

import automata.State;
import grammar.Grammar;
import grammar.Production;
import gui.SplitPaneFactory;
import gui.action.GrammarTransformAction;
import gui.editor.ArrowNontransitionTool;
import gui.editor.EditorPane;
import gui.editor.Tool;
import gui.editor.ToolBox;
import gui.editor.TransitionTool;
import gui.environment.FrameFactory;
import gui.environment.GrammarEnvironment;
import gui.grammar.GrammarTable;
import gui.grammar.GrammarTableModel;
import gui.grammar.transform.UnitController;
import gui.viewer.AutomatonDrawer;
import gui.viewer.AutomatonPane;
import gui.viewer.SelectionDrawer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class UnitPane
extends JPanel {
    GrammarEnvironment environment;
    Grammar grammar;
    UnitController controller;
    GrammarTable grammarTable;
    JLabel mainLabel = new JLabel(" ");
    JLabel detailLabel = new JLabel(" ");
    EditorPane vdgEditor;
    SelectionDrawer vdgDrawer;
    AbstractAction doStepAction = new AbstractAction("Do Step"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            UnitPane.this.controller.doStep();
        }
    };
    AbstractAction doAllAction = new AbstractAction("Do All"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            UnitPane.this.controller.doAll();
        }
    };
    AbstractAction proceedAction = new AbstractAction("Proceed"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GrammarTransformAction.hypothesizeUseless(UnitPane.this.environment, UnitPane.this.getGrammar());
        }
    };
    AbstractAction exportAction = new AbstractAction("Export"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FrameFactory.createFrame(UnitPane.this.getGrammar());
        }
    };
    boolean editingActive = false;
    private int editingRow = -1;
    private boolean[] editingColumn = new boolean[2];
    GrammarTableModel editingGrammarModel = new GrammarTableModel(){

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (!UnitPane.this.editingActive) {
                return false;
            }
            if (UnitPane.this.controller.step != 2) {
                return false;
            }
            if (n2 == 1) {
                return false;
            }
            if (UnitPane.this.editingRow == -1) {
                if (n == this.getRowCount() - 1) {
                    UnitPane.this.editingRow = n;
                    ((UnitPane)UnitPane.this).editingColumn[1] = false;
                    ((UnitPane)UnitPane.this).editingColumn[0] = false;
                    return true;
                }
                return false;
            }
            return UnitPane.this.editingRow == n;
        }
    };
    GrammarTable editingGrammarView = new GrammarTable(this.editingGrammarModel);
    AbstractAction deleteAction = new AbstractAction("Delete"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            UnitPane.this.deleteActivated();
        }
    };
    AbstractAction completeSelectedAction = new AbstractAction("Complete Selected"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            UnitPane.this.cancelEditing();
            UnitPane.this.controller.doSelected();
        }
    };

    public UnitPane(GrammarEnvironment grammarEnvironment, Grammar grammar) {
        this.environment = grammarEnvironment;
        this.grammar = grammar;
        this.controller = new UnitController(this, grammar);
        this.initView();
    }

    private void initView() {
        super.setLayout(new BorderLayout());
        this.initGrammarTable();
        JPanel jPanel = this.initRightPanel();
        JSplitPane jSplitPane = SplitPaneFactory.createSplit(this.environment, true, 0.4, new JScrollPane(this.grammarTable), jPanel);
        this.add((Component)jSplitPane, "Center");
    }

    private JPanel initRightPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.mainLabel.setAlignmentX(0.0f);
        this.detailLabel.setAlignmentX(0.0f);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.add(this.mainLabel);
        jPanel2.add(this.detailLabel);
        this.initEditingGrammarTable();
        this.vdgDrawer = new SelectionDrawer(this.controller.vdg);
        this.vdgEditor = new EditorPane(this.vdgDrawer, new ToolBox(){

            @Override
            public List tools(AutomatonPane automatonPane, AutomatonDrawer automatonDrawer) {
                LinkedList<Tool> linkedList = new LinkedList<Tool>();
                linkedList.add(new ArrowNontransitionTool(automatonPane, automatonDrawer){

                    @Override
                    public void mouseClicked(MouseEvent mouseEvent) {
                        super.mouseClicked(mouseEvent);
                        State state = UnitPane.this.vdgDrawer.stateAtPoint(mouseEvent.getPoint());
                        if (UnitPane.this.controller.step == 2) {
                            UnitPane.this.controller.stateClicked(state, mouseEvent);
                        }
                    }
                });
                linkedList.add(new TransitionTool(automatonPane, automatonDrawer));
                return linkedList;
            }
        }, true);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        JToolBar jToolBar = new JToolBar();
        jToolBar.setAlignmentX(0.0f);
        jToolBar.setFloatable(false);
        jToolBar.add(this.deleteAction);
        jToolBar.add(this.completeSelectedAction);
        jPanel3.add((Component)jToolBar, "North");
        jPanel3.add((Component)new JScrollPane(this.editingGrammarView), "Center");
        JSplitPane jSplitPane = SplitPaneFactory.createSplit(this.environment, false, 0.5, this.vdgEditor, jPanel3);
        jPanel2.add(jSplitPane);
        JToolBar jToolBar2 = new JToolBar();
        jToolBar2.setAlignmentX(0.0f);
        jToolBar2.add(this.doStepAction);
        jToolBar2.add(this.doAllAction);
        jToolBar2.addSeparator();
        jToolBar2.add(this.proceedAction);
        jToolBar2.add(this.exportAction);
        jPanel.add((Component)jToolBar2, "North");
        jPanel.add((Component)jPanel2, "Center");
        return jPanel;
    }

    private GrammarTable initGrammarTable() {
        this.grammarTable = new GrammarTable(new GrammarTableModel(this.grammar){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        });
        return this.grammarTable;
    }

    void updateDeleteEnabledness() {
        if (this.controller.step != 2) {
            this.deleteAction.setEnabled(false);
            return;
        }
        int n = this.editingGrammarView.getSelectionModel().getMinSelectionIndex();
        if (n == -1 || n >= this.editingGrammarModel.getRowCount() - 1) {
            this.deleteAction.setEnabled(false);
            return;
        }
        this.deleteAction.setEnabled(true);
    }

    void updateCompleteSelectedEnabledness() {
        if (this.controller.step != 2) {
            this.completeSelectedAction.setEnabled(false);
            return;
        }
        int n = this.editingGrammarView.getSelectionModel().getMinSelectionIndex();
        if (n == -1 || n >= this.editingGrammarModel.getRowCount() - 1) {
            this.completeSelectedAction.setEnabled(false);
            return;
        }
        this.completeSelectedAction.setEnabled(true);
    }

    private void initEditingGrammarTable() {
        this.editingGrammarModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                if (!UnitPane.this.editingActive) {
                    return;
                }
                int n = tableModelEvent.getFirstRow();
                if (tableModelEvent.getType() != 0) {
                    return;
                }
                ((UnitPane)UnitPane.this).editingColumn[tableModelEvent.getColumn() >> 1] = true;
                if (UnitPane.this.editingColumn[0] && UnitPane.this.editingColumn[1]) {
                    Production production = UnitPane.this.editingGrammarModel.getProduction(n);
                    if (production == null) {
                        return;
                    }
                    if (!UnitPane.this.controller.productionAdded(production, n)) {
                        UnitPane.this.editingGrammarModel.deleteRow(n);
                    }
                    UnitPane.this.editingRow = -1;
                }
            }
        });
        this.editingGrammarView.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                UnitPane.this.updateDeleteEnabledness();
                UnitPane.this.updateCompleteSelectedEnabledness();
            }
        });
        Object object = new Object();
        this.editingGrammarView.getInputMap().put(KeyStroke.getKeyStroke(8, 0), object);
        this.editingGrammarView.getInputMap().put(KeyStroke.getKeyStroke(127, 0), object);
        this.editingGrammarView.getActionMap().put(object, this.deleteAction);
    }

    void cancelEditing() {
        if (this.editingGrammarView.getCellEditor() != null) {
            this.editingGrammarView.getCellEditor().stopCellEditing();
        }
        if (this.editingRow != -1) {
            this.editingGrammarModel.deleteRow(this.editingRow);
            this.editingRow = -1;
        }
    }

    public Grammar getGrammar() {
        Grammar grammar = this.editingGrammarView.getGrammar(this.grammar.getClass());
        Production[] productionArray = grammar.getProductions();
        final String string = this.grammar.getStartVariable();
        Arrays.sort(productionArray, new Comparator(){

            public int compare(Object object, Object object2) {
                Production production = (Production)object;
                Production production2 = (Production)object2;
                if (string.equals(production.getLHS())) {
                    if (production.getLHS().equals(production2.getLHS())) {
                        return 0;
                    }
                    return -1;
                }
                if (string.equals(production2.getLHS())) {
                    return 1;
                }
                return production.getLHS().compareTo(production2.getRHS());
            }
        });
        Grammar grammar2 = null;
        try {
            grammar2 = (Grammar)grammar.getClass().newInstance();
            grammar2.addProductions(productionArray);
            grammar2.setStartVariable(string);
        }
        catch (Throwable throwable) {
            System.err.println("BADNESS!");
            System.err.println(throwable);
            return grammar2;
        }
        return grammar2;
    }

    private void deleteActivated() {
        if (this.controller.step != 2) {
            return;
        }
        this.cancelEditing();
        int n = 0;
        int n2 = 0;
        for (int i = this.editingGrammarModel.getRowCount() - 2; i >= 0; --i) {
            if (!this.editingGrammarView.isRowSelected(i)) continue;
            Production production = this.editingGrammarModel.getProduction(i);
            if (this.controller.productionDeleted(production, i)) {
                this.editingGrammarModel.deleteRow(i);
                ++n;
                continue;
            }
            ++n2;
        }
        if (n2 != 0) {
            JOptionPane.showMessageDialog(this, n2 + " production(s) selected should not be removed.\n" + n + " production(s) were removed.", "Bad Selection", 0);
        }
        if (n != 0) {
            this.controller.updateDisplay();
        }
    }
}

