/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar.transform;

import grammar.Grammar;
import grammar.Production;
import gui.SplitPaneFactory;
import gui.TableTextSizeSlider;
import gui.action.GrammarTransformAction;
import gui.environment.FrameFactory;
import gui.environment.GrammarEnvironment;
import gui.grammar.GrammarTable;
import gui.grammar.GrammarTableModel;
import gui.grammar.transform.LambdaController;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class LambdaPane
extends JPanel {
    GrammarEnvironment environment;
    Grammar grammar;
    LambdaController controller;
    GrammarTable grammarTable;
    JLabel mainLabel = new JLabel(" ");
    JLabel detailLabel = new JLabel(" ");
    JLabel lambdaDerivingLabel = new JLabel(" ");
    AbstractAction doStepAction = new AbstractAction("Do Step"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LambdaPane.this.controller.doStep();
        }
    };
    AbstractAction doAllAction = new AbstractAction("Do All"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LambdaPane.this.controller.doAll();
        }
    };
    AbstractAction proceedAction = new AbstractAction("Proceed"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GrammarTransformAction.hypothesizeUnit(LambdaPane.this.environment, LambdaPane.this.getGrammar());
        }
    };
    AbstractAction exportAction = new AbstractAction("Export"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FrameFactory.createFrame(LambdaPane.this.editingGrammarView.getGrammar(LambdaPane.this.grammar.getClass()));
        }
    };
    boolean editingActive = false;
    private int editingRow = -1;
    private boolean[] editingColumn = new boolean[2];
    GrammarTableModel editingGrammarModel = new GrammarTableModel(){

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (LambdaPane.this.controller.step != 2) {
                return false;
            }
            if (n2 == 1) {
                return false;
            }
            if (LambdaPane.this.editingRow == -1) {
                if (n == this.getRowCount() - 1) {
                    LambdaPane.this.editingRow = n;
                    ((LambdaPane)LambdaPane.this).editingColumn[1] = false;
                    ((LambdaPane)LambdaPane.this).editingColumn[0] = false;
                    return true;
                }
                return false;
            }
            return LambdaPane.this.editingRow == n;
        }
    };
    GrammarTable editingGrammarView = new GrammarTable(this.editingGrammarModel);
    AbstractAction deleteAction = new AbstractAction("Delete"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LambdaPane.this.deleteActivated();
        }
    };
    AbstractAction completeSelectedAction = new AbstractAction("Complete Selected"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LambdaPane.this.cancelEditing();
            for (int i = 0; i < LambdaPane.this.grammarTable.getRowCount() - 1; ++i) {
                if (!LambdaPane.this.grammarTable.isRowSelected(i)) continue;
                LambdaPane.this.controller.expandRowProduction(i);
            }
        }
    };

    public LambdaPane(GrammarEnvironment grammarEnvironment, Grammar grammar) {
        this.environment = grammarEnvironment;
        this.grammar = grammar;
        this.controller = new LambdaController(this, grammar);
        this.initView();
    }

    private void initView() {
        super.setLayout(new BorderLayout());
        this.initGrammarTable();
        JPanel jPanel = this.initRightPanel();
        JSplitPane jSplitPane = SplitPaneFactory.createSplit(this.environment, true, 0.4, new JScrollPane(this.grammarTable), jPanel);
        this.add((Component)jSplitPane, "Center");
        this.add((Component)new TableTextSizeSlider(this.grammarTable), "North");
    }

    private JPanel initRightPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.mainLabel.setAlignmentX(0.0f);
        this.detailLabel.setAlignmentX(0.0f);
        this.lambdaDerivingLabel.setAlignmentX(0.0f);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.add(this.mainLabel);
        jPanel2.add(this.detailLabel);
        jPanel2.add(this.lambdaDerivingLabel);
        this.initEditingGrammarTable();
        JToolBar jToolBar = new JToolBar();
        jToolBar.setAlignmentX(0.0f);
        jToolBar.setFloatable(false);
        jToolBar.add(this.deleteAction);
        jToolBar.add(this.completeSelectedAction);
        jPanel2.add(jToolBar);
        jPanel2.add(new JScrollPane(this.editingGrammarView));
        JToolBar jToolBar2 = new JToolBar();
        jToolBar2.setAlignmentX(0.0f);
        jToolBar2.add(this.doStepAction);
        jToolBar2.add(this.doAllAction);
        jToolBar2.addSeparator();
        jToolBar2.add(this.proceedAction);
        jToolBar2.add(this.exportAction);
        jPanel.add((Component)jToolBar2, "North");
        jPanel.add((Component)jPanel2, "Center");
        return jPanel;
    }

    private GrammarTable initGrammarTable() {
        this.grammarTable = new GrammarTable(new GrammarTableModel(this.grammar){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        });
        this.grammarTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Point point;
                GrammarTable grammarTable = (GrammarTable)mouseEvent.getSource();
                int n = grammarTable.rowAtPoint(point = mouseEvent.getPoint());
                if (n == -1) {
                    return;
                }
                if (n == grammarTable.getGrammarModel().getRowCount() - 1) {
                    return;
                }
                Production production = grammarTable.getGrammarModel().getProduction(n);
                LambdaPane.this.controller.productionClicked(production, mouseEvent);
            }
        });
        this.grammarTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                LambdaPane.this.updateCompleteSelectedEnabledness();
            }
        });
        return this.grammarTable;
    }

    void updateDeleteEnabledness() {
        if (this.controller.step != 2) {
            this.deleteAction.setEnabled(false);
            return;
        }
        int n = this.editingGrammarView.getSelectionModel().getMinSelectionIndex();
        if (n == -1 || n >= this.editingGrammarModel.getRowCount() - 1) {
            this.deleteAction.setEnabled(false);
            return;
        }
        this.deleteAction.setEnabled(true);
    }

    void updateCompleteSelectedEnabledness() {
        if (this.controller.step != 2) {
            this.completeSelectedAction.setEnabled(false);
            return;
        }
        int n = this.grammarTable.getSelectionModel().getMinSelectionIndex();
        if (n == -1 || n >= this.grammarTable.getGrammarModel().getRowCount() - 1) {
            this.completeSelectedAction.setEnabled(false);
            return;
        }
        this.completeSelectedAction.setEnabled(true);
    }

    private void initEditingGrammarTable() {
        this.editingGrammarModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                if (!LambdaPane.this.editingActive) {
                    return;
                }
                int n = tableModelEvent.getFirstRow();
                if (tableModelEvent.getType() != 0) {
                    return;
                }
                ((LambdaPane)LambdaPane.this).editingColumn[tableModelEvent.getColumn() >> 1] = true;
                if (LambdaPane.this.editingColumn[0] && LambdaPane.this.editingColumn[1]) {
                    Production production = LambdaPane.this.editingGrammarModel.getProduction(n);
                    if (production == null) {
                        return;
                    }
                    if (!LambdaPane.this.controller.productionAdded(production, n)) {
                        LambdaPane.this.editingGrammarModel.deleteRow(n);
                    }
                    LambdaPane.this.editingRow = -1;
                }
            }
        });
        this.editingGrammarView.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                LambdaPane.this.updateDeleteEnabledness();
            }
        });
        Object object = new Object();
        this.editingGrammarView.getInputMap().put(KeyStroke.getKeyStroke(8, 0), object);
        this.editingGrammarView.getInputMap().put(KeyStroke.getKeyStroke(127, 0), object);
        this.editingGrammarView.getActionMap().put(object, this.deleteAction);
    }

    void cancelEditing() {
        if (this.editingGrammarView.getCellEditor() != null) {
            this.editingGrammarView.getCellEditor().stopCellEditing();
        }
        if (this.editingRow != -1) {
            this.editingGrammarModel.deleteRow(this.editingRow);
            this.editingRow = -1;
        }
    }

    public Grammar getGrammar() {
        return this.editingGrammarView.getGrammar(this.grammar.getClass());
    }

    private void deleteActivated() {
        if (this.controller.step != 2) {
            return;
        }
        this.cancelEditing();
        int n = 0;
        int n2 = 0;
        for (int i = this.editingGrammarModel.getRowCount() - 2; i >= 0; --i) {
            if (!this.editingGrammarView.isRowSelected(i)) continue;
            Production production = this.editingGrammarModel.getProduction(i);
            if (this.controller.productionDeleted(production, i)) {
                this.editingGrammarModel.deleteRow(i);
                ++n;
                continue;
            }
            ++n2;
        }
        if (n2 != 0) {
            JOptionPane.showMessageDialog(this, n2 + " production(s) selected should not be removed.\n" + n + " production(s) were removed.", "Bad Selection", 0);
        }
        if (n != 0) {
            this.controller.updateDisplay();
        }
    }
}

