/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar.transform;

import grammar.Grammar;
import grammar.LambdaProductionRemover;
import grammar.Production;
import gui.grammar.GrammarTableModel;
import gui.grammar.transform.LambdaPane;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JOptionPane;

public class LambdaController {
    LambdaPane pane;
    Grammar grammar;
    LambdaProductionRemover remover = new LambdaProductionRemover();
    Set lambdaVariables;
    Set derivedLambdaVariables;
    Set desiredProductions = new HashSet();
    Set currentProductions = new HashSet();
    Set lambdaProductions = new HashSet();
    Map productionsToExpansion = new HashMap();
    int step = 0;
    static final int VARAIBLE_SELECT = 1;
    static final int PRODUCTION_MODIFY = 2;
    static final int FINISHED = 3;

    public LambdaController(LambdaPane lambdaPane, Grammar grammar) {
        this.pane = lambdaPane;
        this.grammar = grammar;
        this.nextStep();
    }

    private void nextStep() {
        if (this.step != 3) {
            ++this.step;
        }
        switch (this.step) {
            case 1: {
                this.pane.mainLabel.setText("Select variables that derive lambda.");
                this.pane.detailLabel.setText("Click productions; the LHS variable will be added.");
                this.lambdaVariables = this.remover.getCompleteLambdaSet(this.grammar);
                this.derivedLambdaVariables = new TreeSet();
                this.pane.deleteAction.setEnabled(false);
                this.pane.completeSelectedAction.setEnabled(false);
                this.pane.doStepAction.setEnabled(true);
                this.pane.doAllAction.setEnabled(true);
                this.pane.proceedAction.setEnabled(false);
                this.pane.exportAction.setEnabled(false);
                break;
            }
            case 2: {
                this.pane.updateDeleteEnabledness();
                this.pane.updateCompleteSelectedEnabledness();
                this.pane.mainLabel.setText("Modify the grammar to remove lambdas.");
                Production[] productionArray = this.grammar.getProductions();
                for (int i = 0; i < productionArray.length; ++i) {
                    this.pane.editingGrammarModel.addProduction(productionArray[i]);
                    this.currentProductions.add(productionArray[i]);
                    if (productionArray[i].getRHS().length() == 0) {
                        this.lambdaProductions.add(productionArray[i]);
                        continue;
                    }
                    Production[] productionArray2 = this.remover.getProductionsToAddForProduction(productionArray[i], this.lambdaVariables);
                    this.desiredProductions.add(productionArray[i]);
                    this.productionsToExpansion.put(productionArray[i], productionArray2);
                    for (int j = 0; j < productionArray2.length; ++j) {
                        this.desiredProductions.add(productionArray2[j]);
                    }
                }
                this.pane.editingActive = true;
                this.updateDisplay();
                break;
            }
            case 3: {
                this.pane.deleteAction.setEnabled(false);
                this.pane.completeSelectedAction.setEnabled(false);
                this.pane.mainLabel.setText("Lambda removal complete.");
                this.pane.detailLabel.setText("\"Proceed\" or \"Export\" available.");
                this.pane.doStepAction.setEnabled(false);
                this.pane.doAllAction.setEnabled(false);
                this.pane.proceedAction.setEnabled(true);
                this.pane.exportAction.setEnabled(true);
            }
        }
    }

    public Map getExpansionMap() {
        return this.productionsToExpansion;
    }

    public void expandRowProduction(int n) {
        Production production = this.pane.grammarTable.getGrammarModel().getProduction(n);
        Production[] productionArray = (Production[])this.productionsToExpansion.get(production);
        if (productionArray == null) {
            return;
        }
        this.pane.editingActive = false;
        for (int i = 0; i < productionArray.length; ++i) {
            if (!this.currentProductions.contains(productionArray[i]) && this.desiredProductions.contains(productionArray[i])) {
                this.pane.editingGrammarModel.addProduction(productionArray[i]);
                this.currentProductions.add(productionArray[i]);
            }
            this.productionsToExpansion.remove(production);
        }
        this.pane.editingActive = true;
        this.updateDisplay();
    }

    public void doStep() {
        switch (this.step) {
            case 1: {
                this.derivedLambdaVariables = this.lambdaVariables;
                this.pane.lambdaDerivingLabel.setText("Set that derives lambda: " + this.derivedLambdaVariables);
                this.nextStep();
                break;
            }
            case 2: {
                for (int i = this.pane.editingGrammarModel.getRowCount() - 2; i >= 0; --i) {
                    Production production = this.pane.editingGrammarModel.getProduction(i);
                    if (!this.lambdaProductions.contains(production)) continue;
                    this.pane.editingGrammarModel.deleteRow(i);
                    this.lambdaProductions.remove(production);
                }
                GrammarTableModel grammarTableModel = this.pane.grammarTable.getGrammarModel();
                for (int i = 0; i < grammarTableModel.getRowCount() - 1; ++i) {
                    this.expandRowProduction(i);
                }
                this.nextStep();
                break;
            }
        }
    }

    public void doAll() {
        while (this.step != 3) {
            this.doStep();
        }
    }

    public Grammar getGrammar() {
        return this.pane.getGrammar();
    }

    public Set getLambdaSet() {
        return this.lambdaProductions;
    }

    void updateDisplay() {
        int n = this.lambdaProductions.size();
        int n2 = this.desiredProductions.size() - this.currentProductions.size() + this.lambdaProductions.size();
        this.pane.detailLabel.setText(n + " more remove(s), and " + n2 + " more addition(s) needed.");
        if (n2 == 0 && n == 0) {
            this.nextStep();
        }
    }

    void productionClicked(Production production, MouseEvent mouseEvent) {
        switch (this.step) {
            case 1: {
                String string = production.getLHS();
                if (this.derivedLambdaVariables.contains(string)) {
                    this.pane.detailLabel.setText(string + " already selected!  " + (this.lambdaVariables.size() - this.derivedLambdaVariables.size()) + " more variable(s) needed.");
                    return;
                }
                if (this.lambdaVariables.contains(string)) {
                    this.derivedLambdaVariables.add(string);
                    this.pane.detailLabel.setText(string + " added!  " + (this.lambdaVariables.size() - this.derivedLambdaVariables.size()) + " more variable(s) needed.");
                    this.pane.lambdaDerivingLabel.setText("Set that derives lambda: " + this.derivedLambdaVariables);
                    if (this.derivedLambdaVariables.size() == this.lambdaVariables.size()) {
                        this.nextStep();
                    }
                    return;
                }
                this.pane.detailLabel.setText(string + " does not derive lambda!  " + (this.lambdaVariables.size() - this.derivedLambdaVariables.size()) + " more variable(s) needed.");
                break;
            }
            case 2: {
                break;
            }
        }
    }

    boolean productionAdded(Production production, int n) {
        if (this.currentProductions.contains(production)) {
            JOptionPane.showMessageDialog(this.pane, "This production is already in the grammar.", "Production Already Here", 0);
            return false;
        }
        if (!this.desiredProductions.contains(production)) {
            JOptionPane.showMessageDialog(this.pane, "This production is not part of the reformed grammar.", "Production Not Desired", 0);
            return false;
        }
        this.currentProductions.add(production);
        this.updateDisplay();
        return true;
    }

    boolean productionDeleted(Production production, int n) {
        if (!this.lambdaProductions.contains(production)) {
            return false;
        }
        this.lambdaProductions.remove(production);
        this.currentProductions.remove(production);
        return true;
    }
}

