/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar.parse;

import grammar.Grammar;
import grammar.Production;
import grammar.parse.LRParseTable;
import gui.environment.Universe;
import gui.grammar.parse.LRParsePane;
import gui.tree.Trees;
import java.util.ArrayList;
import java.util.Stack;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

class LRParseController {
    private IntStack STACK;
    private Production[] productions;
    private int P;
    private String STRING;
    private int NODECOUNT;
    private int reduceStep = 0;
    private int reduceState;
    private LRParsePane pane;
    private DefaultTreeModel tree;
    private TreeNode[] nodes;

    public LRParseController(LRParsePane lRParsePane) {
        this.pane = lRParsePane;
        this.productions = lRParsePane.grammar.getProductions();
    }

    public void initialize(String string) {
        DefaultTreeModel defaultTreeModel = this.tree;
        this.tree = this.parseTree(string, this.pane.grammar, this.pane.table);
        if (this.tree == null) {
            this.tree = defaultTreeModel;
            this.pane.statusDisplay.setText("Preliminary parse failed.");
            return;
        }
        this.dehighlight();
        this.pane.treeDrawer.setModel(this.tree);
        this.pane.treeDrawer.hideAll();
        this.pane.treePanel.repaint();
        this.pane.stepAction.setEnabled(true);
        this.pane.derivationModel.setRowCount(0);
        this.pane.derivationModel.addRow(new String[]{"", string});
        this.reduceStep = 0;
        this.STRING = string + "$";
        this.P = 0;
        this.STACK = new IntStack();
        this.NODECOUNT = 0;
        this.STACK.push(0);
        this.updateStatus();
        this.pane.statusDisplay.setText("Press step to begin.");
    }

    private void updateStatus() {
        this.pane.stackDisplay.setText(this.stackString());
        this.pane.inputDisplay.setText(this.STRING.substring(this.P));
    }

    private String stackString() {
        Object[] objectArray = this.STACK.toArray();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = objectArray.length - 1; i >= 0; --i) {
            stringBuffer.append(objectArray[i]);
        }
        return stringBuffer.toString();
    }

    private String derivationString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 1; i < this.STACK.size(); i += 2) {
            stringBuffer.append(this.STACK.get(i));
        }
        stringBuffer.append(this.STRING.substring(this.P, this.STRING.length() - 1));
        return stringBuffer.toString();
    }

    public void step() {
        this.dehighlight();
        int n = this.STACK.peekInt();
        if (this.reduceStep == 1) {
            n = this.reduceState;
        }
        String string = "" + this.STRING.charAt(this.P);
        String string2 = "";
        try {
            string2 = this.pane.table.getValueAt(n, string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (string2.length() == 0 || Character.isDigit(string2.charAt(0))) {
            this.pane.stepAction.setEnabled(false);
            this.pane.statusDisplay.setText("String rejected");
        } else if (string2.charAt(0) == 's') {
            int n2 = Integer.parseInt(string2.substring(1));
            this.STACK.push(string);
            this.STACK.push(n2);
            ++this.P;
            this.pane.treeDrawer.show(this.nodes[this.NODECOUNT++]);
            this.pane.treePanel.repaint();
            this.pane.statusDisplay.setText("Shifting " + string);
            this.highlight(n, string);
        } else if (string2.charAt(0) == 'r') {
            int n3 = Integer.parseInt(string2.substring(1));
            Production production = this.productions[n3];
            String string3 = "Reducing by " + production + ", ";
            this.highlight(n3);
            if (this.reduceStep == 0) {
                this.highlight(n, string);
                TreeNode[] treeNodeArray = Trees.children(this.nodes[this.NODECOUNT]);
                if (treeNodeArray.length == 1 && !this.pane.treeDrawer.isVisible(treeNodeArray[0])) {
                    this.pane.statusDisplay.setText(string3);
                    this.pane.treeDrawer.show(treeNodeArray[0]);
                    this.pane.treePanel.repaint();
                }
                String string4 = "";
                for (int i = 0; i < production.getRHS().length(); ++i) {
                    this.STACK.pop();
                    string4 = this.STACK.pop() + string4;
                }
                if (string4.length() == 0) {
                    string4 = Universe.curProfile.getEmptyString();
                }
                string3 = string3 + string4 + " popped off stack";
                this.reduceStep = 1;
                this.reduceState = n;
            } else if (this.reduceStep == 1) {
                n = this.STACK.peekInt();
                this.highlight(n, production.getLHS());
                string3 = string3 + production.getLHS() + " pushed on stack";
                this.STACK.push(production.getLHS());
                this.STACK.push(Integer.parseInt(this.pane.table.getValueAt(n, production.getLHS())));
                this.pane.treeDrawer.show(this.nodes[this.NODECOUNT++]);
                this.pane.derivationModel.addRow(new String[]{production.toString(), this.derivationString()});
                this.reduceStep = 0;
            }
            this.pane.statusDisplay.setText(string3);
            this.pane.treePanel.repaint();
        } else if (string2.charAt(0) == 'a') {
            this.STACK.pop();
            this.pane.stepAction.setEnabled(false);
            this.pane.statusDisplay.setText("String accepted");
            this.highlight(n, string);
        }
        this.updateStatus();
    }

    private void highlight(int n, String string) {
        int n2 = this.pane.table.columnForSymbol(string);
        this.pane.tablePanel.highlight(n, n2);
        this.pane.tablePanel.repaint();
        this.pane.grammarTable.repaint();
    }

    private void highlight(int n) {
        this.pane.grammarTable.highlight(n, 0);
        this.pane.grammarTable.highlight(n, 2);
        this.pane.tablePanel.repaint();
        this.pane.grammarTable.repaint();
    }

    private void dehighlight() {
        this.pane.tablePanel.dehighlight();
        this.pane.grammarTable.dehighlight();
    }

    private DefaultTreeModel parseTree(String string, Grammar grammar, LRParseTable lRParseTable) {
        string = string + "$";
        int n = 0;
        int n2 = 0;
        int n3 = 500;
        IntStack intStack = new IntStack();
        intStack.push(0);
        Production[] productionArray = grammar.getProductions();
        ArrayList<DefaultMutableTreeNode> arrayList = new ArrayList<DefaultMutableTreeNode>();
        while (true) {
            Object object;
            int n4 = intStack.peekInt();
            String string2 = "" + string.charAt(n);
            String string3 = "";
            try {
                string3 = lRParseTable.getValueAt(n4, string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (string3.length() == 0 || Character.isDigit(string3.charAt(0))) {
                DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
                object = intStack.toArray();
                for (int i = 0; i < ((Object[])object).length; ++i) {
                    if (!(object[i] instanceof MutableTreeNode)) continue;
                    defaultMutableTreeNode.add((MutableTreeNode)object[i]);
                }
                this.nodes = arrayList.toArray(new TreeNode[0]);
                return new DefaultTreeModel(defaultMutableTreeNode);
            }
            if (string3.charAt(0) == 's') {
                DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string2, false);
                intStack.push(defaultMutableTreeNode);
                arrayList.add(defaultMutableTreeNode);
                intStack.push(Integer.parseInt(string3.substring(1)));
                ++n;
            } else if (string3.charAt(0) == 'r') {
                int n5 = Integer.parseInt(string3.substring(1));
                object = productionArray[n5];
                DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(((Production)object).getLHS());
                for (int i = 0; i < ((Production)object).getRHS().length(); ++i) {
                    intStack.pop();
                    MutableTreeNode mutableTreeNode = (MutableTreeNode)intStack.pop();
                    defaultMutableTreeNode.insert(mutableTreeNode, 0);
                }
                if (((Production)object).getRHS().length() == 0) {
                    DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(Universe.curProfile.getEmptyString());
                    defaultMutableTreeNode.insert(defaultMutableTreeNode2, 0);
                }
                n4 = intStack.peekInt();
                intStack.push(defaultMutableTreeNode);
                intStack.push(Integer.parseInt(lRParseTable.getValueAt(n4, ((Production)object).getLHS())));
                arrayList.add(defaultMutableTreeNode);
            } else if (string3.charAt(0) == 'a') {
                intStack.pop();
                this.nodes = arrayList.toArray(new TreeNode[0]);
                return new DefaultTreeModel((TreeNode)intStack.pop());
            }
            if (++n2 < n3) continue;
            int n6 = JOptionPane.showConfirmDialog(this.pane, n2 + " nodes have been generated.  Should we continue?");
            if (n6 == 1) {
                return null;
            }
            n3 *= 2;
        }
    }

    private static class IntStack
    extends Stack {
        private IntStack() {
        }

        int push(int n) {
            this.push(new Integer(n));
            return n;
        }

        int popInt() {
            return (Integer)this.pop();
        }

        int peekInt() {
            return (Integer)this.peek();
        }
    }
}

