/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar.parse;

import grammar.Grammar;
import gui.HighlightTable;
import gui.LeftTable;
import gui.environment.Universe;
import gui.grammar.parse.FirstFollowModel;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class FirstFollowTable
extends LeftTable {
    private FirstFollowModel model = (FirstFollowModel)this.getModel();
    private static final HighlightTable.TableHighlighterRendererGenerator THRG = new HighlightTable.TableHighlighterRendererGenerator(){
        private DefaultTableCellRenderer renderer = null;

        @Override
        public TableCellRenderer getRenderer(int n, int n2) {
            if (this.renderer == null) {
                this.renderer = new SetsCellRenderer();
                this.renderer.setBackground(new Color(255, 150, 150));
            }
            return this.renderer;
        }
    };
    private static final TableCellRenderer RENDERER = new SetsCellRenderer();

    public FirstFollowTable(Grammar grammar) {
        super(new FirstFollowModel(grammar));
        this.getColumnModel().getColumn(1).setCellRenderer(RENDERER);
        this.getColumnModel().getColumn(2).setCellRenderer(RENDERER);
        this.setCellSelectionEnabled(true);
    }

    public FirstFollowModel getFFModel() {
        return this.model;
    }

    private static String getSetString(String string) {
        if (string == null) {
            return "{ }";
        }
        StringBuffer stringBuffer = new StringBuffer("{ ");
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '!') {
                c = Universe.curProfile.getEmptyString().charAt(0);
            }
            stringBuffer.append(c);
            if (i != string.length() - 1) {
                stringBuffer.append(',');
            }
            stringBuffer.append(' ');
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    @Override
    public void highlight(int n, int n2) {
        this.highlight(n, n2, THRG);
    }

    private static class SetsCellRenderer
    extends DefaultTableCellRenderer {
        private SetsCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (bl2 && jTable.isCellEditable(n, n2)) {
                return jLabel;
            }
            jLabel.setText(FirstFollowTable.getSetString((String)object));
            return jLabel;
        }
    }
}

