/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar.convert;

import grammar.Grammar;
import grammar.Production;
import gui.event.SelectionEvent;
import gui.event.SelectionListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class GrammarViewer
extends JTable {
    private Grammar grammar;
    private ButtonGroup bgroup = new ButtonGroup();
    private Object[][] data;
    private Map productionToRow = new HashMap();
    private SelectionEvent EVENT = new SelectionEvent(this);
    private Set selectionListeners = new HashSet();
    private ListSelectionListener listSelectListener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            GrammarViewer.this.distributeSelectionEvent();
        }
    };

    public GrammarViewer(Grammar grammar) {
        this.setModel(new GrammarTableModel());
        this.grammar = grammar;
        Production[] productionArray = grammar.getProductions();
        this.data = new Object[productionArray.length][2];
        Object[] objectArray = new Object[]{"Production", "Created"};
        for (int i = 0; i < productionArray.length; ++i) {
            this.data[i][0] = productionArray[i];
            this.data[i][1] = Boolean.FALSE;
            this.productionToRow.put(productionArray[i], new Integer(i));
        }
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.getModel();
        defaultTableModel.setDataVector(this.data, objectArray);
        this.getSelectionModel().addListSelectionListener(this.listSelectListener);
    }

    public Grammar getGrammar() {
        return this.grammar;
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.selectionListeners.add(selectionListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.selectionListeners.remove(selectionListener);
    }

    protected void distributeSelectionEvent() {
        for (SelectionListener selectionListener : this.selectionListeners) {
            selectionListener.selectionChanged(this.EVENT);
        }
    }

    public Production[] getSelected() {
        int[] nArray = this.getSelectedRows();
        Production[] productionArray = new Production[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            productionArray[i] = (Production)this.data[nArray[i]][0];
        }
        return productionArray;
    }

    public void setChecked(Production production, boolean bl) {
        Integer n = (Integer)this.productionToRow.get(production);
        if (n == null) {
            return;
        }
        int n2 = n;
        Boolean bl2 = bl ? Boolean.TRUE : Boolean.FALSE;
        this.data[n2][1] = bl2;
        ((DefaultTableModel)this.getModel()).setValueAt(bl2, n2, 1);
    }

    private class GrammarTableModel
    extends DefaultTableModel {
        private GrammarTableModel() {
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            if (n == 1) {
                return Boolean.class;
            }
            return super.getColumnClass(n);
        }
    }
}

