/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar;

import grammar.Grammar;
import grammar.Production;
import gui.GrowableTableModel;
import gui.grammar.ArrowIcon;
import java.util.ArrayList;
import javax.swing.Icon;

public class GrammarTableModel
extends GrowableTableModel {
    private static Icon ARROW = new ArrowIcon(20, 8);

    public GrammarTableModel() {
        super(3);
    }

    public GrammarTableModel(Grammar grammar) {
        this();
        Production[] productionArray = grammar.getProductions();
        for (int i = 0; i < productionArray.length; ++i) {
            this.addProduction(productionArray[i]);
        }
    }

    public int addProduction(Production production) {
        int n = this.getRowCount() - 1;
        this.setValueAt(production.getLHS(), n, 0);
        this.setValueAt(production.getRHS(), n, 2);
        return n;
    }

    public int addProduction(Production production, int n) {
        Object[] objectArray = this.initializeRow(n);
        objectArray[0] = production.getLHS();
        objectArray[2] = production.getRHS();
        this.insertRow(objectArray, n);
        return n;
    }

    @Override
    public String getColumnName(int n) {
        return "";
    }

    public Production getProduction(int n) {
        String string = (String)this.getValueAt(n, 0);
        if (string.equals("")) {
            return null;
        }
        return new Production(string, (String)this.getValueAt(n, 2));
    }

    public Production[] getProductions() {
        ArrayList<Production> arrayList = new ArrayList<Production>();
        for (int i = 0; i < this.getRowCount() - 1; ++i) {
            Production production = this.getProduction(i);
            if (production == null) continue;
            arrayList.add(production);
        }
        return arrayList.toArray(new Production[0]);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 != 1;
    }

    @Override
    protected Object[] initializeRow(int n) {
        Object[] objectArray = new Object[]{"", ARROW, ""};
        return objectArray;
    }

    public Class getColumnClass(int n) {
        return n == 1 ? Icon.class : String.class;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n2 == 1 && n == this.getRowCount() - 1) {
            return null;
        }
        return super.getValueAt(n, n2);
    }
}

