/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar;

import debug.EDebug;
import grammar.Grammar;
import grammar.Production;
import gui.HighlightTable;
import gui.TableTextSizeSlider;
import gui.environment.Universe;
import gui.grammar.GrammarTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class GrammarTable
extends HighlightTable {
    private static final HighlightTable.TableHighlighterRendererGenerator THRG = new HighlightTable.TableHighlighterRendererGenerator(){
        private DefaultTableCellRenderer renderer = null;

        @Override
        public TableCellRenderer getRenderer(int n, int n2) {
            if (this.renderer == null) {
                this.renderer = new LambdaCellRenderer();
                this.renderer.setBackground(new Color(255, 150, 150));
            }
            return this.renderer;
        }
    };
    private static final TableCellRenderer RENDERER = new LambdaCellRenderer();

    public GrammarTable() {
        super(new GrammarTableModel());
        this.initView();
    }

    public GrammarTable(GrammarTableModel grammarTableModel) {
        super(grammarTableModel);
        this.initView();
    }

    public void highlight(int n) {
        this.highlight(n, 0);
        this.highlight(n, 2);
    }

    private void initView() {
        this.setTableHeader(new JTableHeader(this.getColumnModel()));
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().setResizingAllowed(true);
        TableColumn tableColumn = this.getColumnModel().getColumn(0);
        TableColumn tableColumn2 = this.getColumnModel().getColumn(1);
        TableColumn tableColumn3 = this.getColumnModel().getColumn(2);
        tableColumn.setHeaderValue("LHS");
        this.getTableHeader().resizeAndRepaint();
        tableColumn3.setHeaderValue("RHS");
        this.getTableHeader().resizeAndRepaint();
        this.getColumnModel().getColumn(0).setPreferredWidth(70);
        tableColumn.setMaxWidth(200);
        tableColumn2.setMaxWidth(30);
        tableColumn2.setMinWidth(30);
        this.getColumnModel().getColumn(1).setPreferredWidth(30);
        this.setShowGrid(true);
        this.setGridColor(Color.lightGray);
        this.rowHeight = 30;
        this.setFont(new Font("TimesRoman", 0, 20));
        this.getColumnModel().getColumn(2).setCellRenderer(RENDERER);
        this.add((Component)new TableTextSizeSlider(this), "North");
    }

    public GrammarTableModel getGrammarModel() {
        return (GrammarTableModel)super.getModel();
    }

    public Grammar getGrammar(Class clazz) {
        Grammar grammar = null;
        try {
            grammar = (Grammar)clazz.newInstance();
        }
        catch (NullPointerException nullPointerException) {
            EDebug.print("Throwing a Null Pointer Back at YOU.");
            throw nullPointerException;
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException("Bad grammar class " + clazz);
        }
        GrammarTableModel grammarTableModel = this.getGrammarModel();
        if (this.getCellEditor() != null) {
            this.getCellEditor().stopCellEditing();
        }
        for (int i = 0; i < grammarTableModel.getRowCount(); ++i) {
            Production production = grammarTableModel.getProduction(i);
            if (production == null) continue;
            try {
                grammar.addProduction(production);
                if (grammar.getStartVariable() != null) continue;
                grammar.setStartVariable(production.getLHS());
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.setRowSelectionInterval(i, i);
                JOptionPane.showMessageDialog(this, illegalArgumentException.getMessage(), "Production Error", 0);
                return null;
            }
        }
        return grammar;
    }

    @Override
    public void highlight(int n, int n2) {
        this.highlight(n, n2, THRG);
    }

    private static class LambdaCellRenderer
    extends DefaultTableCellRenderer {
        private LambdaCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (bl2 && jTable.isCellEditable(n, n2)) {
                return jLabel;
            }
            if (n2 != 2) {
                return jLabel;
            }
            if (!object.equals("")) {
                return jLabel;
            }
            if (jTable.getModel().getValueAt(n, 0).equals("")) {
                return jLabel;
            }
            jLabel.setText(Universe.curProfile.getEmptyString());
            return jLabel;
        }
    }
}

