/*
 * Decompiled with CFR 0.152.
 */
package gui.editor;

import automata.Automaton;
import automata.turing.TuringMachine;
import gui.environment.Universe;
import java.util.Deque;
import java.util.LinkedList;

public class UndoKeeper {
    private Automaton myMaster;
    private Deque<Automaton> myDeck;
    private Deque<Automaton> myBackDeck;
    private int numUndo;
    public boolean sensitive = false;
    private boolean wait = false;

    public UndoKeeper(Automaton automaton) {
        this.myMaster = automaton;
        this.myDeck = new LinkedList<Automaton>();
        this.myBackDeck = new LinkedList<Automaton>();
        this.numUndo = Universe.curProfile.undo_num;
    }

    public void setNumUndo(int n) {
        this.numUndo = n;
    }

    public void setWait() {
        this.wait = true;
    }

    public void saveStatus() {
        if (this.wait) {
            this.wait = false;
            return;
        }
        this.myDeck.push((Automaton)this.myMaster.clone());
        System.out.println();
        if (this.myDeck.size() >= 2) {
            Automaton automaton = this.myDeck.pop();
            Automaton automaton2 = this.myDeck.pop();
            if (automaton.hashCode() == automaton2.hashCode()) {
                this.myDeck.push(automaton);
            } else {
                this.myDeck.push(automaton2);
                this.myDeck.push(automaton);
                this.myBackDeck.clear();
            }
        }
        while (this.myDeck.size() > this.numUndo) {
            this.myDeck.removeLast();
        }
    }

    public void restoreStatus() {
        if (this.myDeck.size() == 0) {
            return;
        }
        Automaton automaton = null;
        while (this.myDeck.size() > 0 && (automaton = this.myDeck.pop()).hashCode() == this.myMaster.hashCode()) {
        }
        if (this.myDeck.size() == 0 && automaton.hashCode() == this.myMaster.hashCode()) {
            return;
        }
        this.sensitive = true;
        this.myBackDeck.push((Automaton)this.myMaster.clone());
        if (this.myMaster instanceof TuringMachine) {
            TuringMachine.become((TuringMachine)this.myMaster, (TuringMachine)automaton);
        } else {
            Automaton.become(this.myMaster, automaton);
        }
        this.sensitive = false;
        this.myMaster.getEnvironmentFrame().repaint();
    }

    public void redo() {
        if (this.myBackDeck.size() == 0) {
            return;
        }
        this.myDeck.push((Automaton)this.myMaster.clone());
        if (this.myMaster instanceof TuringMachine) {
            TuringMachine.become((TuringMachine)this.myMaster, (TuringMachine)this.myBackDeck.pop());
        } else {
            Automaton.become(this.myMaster, this.myBackDeck.pop());
        }
        this.myMaster.getEnvironmentFrame().repaint();
    }
}

