/*
 * Decompiled with CFR 0.152.
 */
package gui.editor;

import automata.State;
import automata.Transition;
import gui.editor.Tool;
import gui.environment.AutomatonEnvironment;
import gui.viewer.AutomatonDrawer;
import gui.viewer.AutomatonPane;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

public class DeleteTool
extends Tool {
    public DeleteTool(AutomatonPane automatonPane, AutomatonDrawer automatonDrawer) {
        super(automatonPane, automatonDrawer);
    }

    @Override
    public String getToolTip() {
        return "Deleter";
    }

    @Override
    protected Icon getIcon() {
        URL uRL = this.getClass().getResource("/ICON/delete.gif");
        return new ImageIcon(uRL);
    }

    @Override
    public KeyStroke getKey() {
        return KeyStroke.getKeyStroke('d');
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        State state;
        if (this.getDrawer().getAutomaton().getEnvironmentFrame() != null) {
            ((AutomatonEnvironment)this.getDrawer().getAutomaton().getEnvironmentFrame().getEnvironment()).saveStatus();
        }
        if ((state = this.getDrawer().stateAtPoint(mouseEvent.getPoint())) != null) {
            this.getAutomaton().removeState(state);
            this.getView().repaint();
            return;
        }
        Transition transition = this.getDrawer().transitionAtPoint(mouseEvent.getPoint());
        if (transition != null) {
            this.getAutomaton().removeTransition(transition);
            this.getView().repaint();
        }
    }
}

