/*
 * Decompiled with CFR 0.152.
 */
package gui.deterministic;

import automata.Automaton;
import automata.State;
import automata.Transition;
import automata.event.AutomataStateEvent;
import automata.event.AutomataStateListener;
import automata.fsa.FSATransition;
import automata.fsa.FiniteStateAutomaton;
import automata.fsa.NFAToDFA;
import automata.graph.Graph;
import automata.graph.LayoutAlgorithm;
import automata.graph.layout.GEMLayoutAlgorithm;
import debug.EDebug;
import gui.deterministic.ConversionPane;
import gui.environment.FrameFactory;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;

public class ConversionController {
    private FiniteStateAutomaton nfa;
    private FiniteStateAutomaton dfa;
    private FiniteStateAutomaton answer;
    private ConversionPane view;
    private NFAToDFA converter = new NFAToDFA();
    private Graph graph = new Graph();
    private boolean validLayout = false;
    private LayoutAlgorithm layout = new GEMLayoutAlgorithm();
    private Map setToState = new HashMap();
    private Map stateToSet = new HashMap();

    public ConversionController(FiniteStateAutomaton finiteStateAutomaton, FiniteStateAutomaton finiteStateAutomaton2, ConversionPane conversionPane) {
        this.nfa = finiteStateAutomaton;
        this.dfa = finiteStateAutomaton2;
        this.view = conversionPane;
        this.converter.createInitialState(finiteStateAutomaton, finiteStateAutomaton2).setPoint(new Point(50, 50));
        this.registerState(finiteStateAutomaton2.getInitialState());
        this.answer = this.converter.convertToDFA(finiteStateAutomaton);
        this.initializeGraph();
    }

    private void initializeGraph() {
        int n;
        HashMap<State, HashSet<State>> hashMap = new HashMap<State, HashSet<State>>();
        State[] stateArray = this.answer.getStates();
        Transition[] transitionArray = this.answer.getTransitions();
        for (n = 0; n < stateArray.length; ++n) {
            HashSet<State> hashSet = new HashSet<State>(Arrays.asList(this.getStatesForString(stateArray[n].getLabel(), this.nfa)));
            hashMap.put(stateArray[n], hashSet);
            this.graph.addVertex(hashSet, stateArray[n].getPoint());
        }
        for (n = 0; n < transitionArray.length; ++n) {
            this.graph.addEdge(hashMap.get(transitionArray[n].getFromState()), hashMap.get(transitionArray[n].getToState()));
        }
    }

    public void performFirstLayout() {
        this.view.validate();
        HashSet<Set> hashSet = new HashSet<Set>();
        Set set = (Set)this.stateToSet.get(this.dfa.getInitialState());
        hashSet.add(set);
        this.graph.addVertex(set, new Point(0, 0));
        this.layout.layout(this.graph, hashSet);
        Rectangle rectangle = this.view.editor.getBounds(null);
        rectangle.grow(-50, -50);
        this.graph.moveWithinFrame(rectangle);
        Point point = new Point();
        point.setLocation(this.graph.pointForVertex(set));
        this.dfa.getInitialState().setPoint(point);
    }

    private State[] getStatesForString(String string, Automaton automaton) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r\f,q");
        ArrayList<State> arrayList = new ArrayList<State>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(automaton.getStateWithID(Integer.parseInt(stringTokenizer.nextToken())));
        }
        arrayList.remove(null);
        return arrayList.toArray(new State[0]);
    }

    private void registerState(State state) {
        HashSet<State> hashSet = new HashSet<State>(Arrays.asList(this.getStatesForString(state.getLabel(), this.nfa)));
        State state2 = (State)this.setToState.get(hashSet);
        EDebug.print(hashSet);
        EDebug.print(state2);
        EDebug.print(state);
        for (Object k : this.setToState.keySet()) {
            EDebug.print(k.toString());
        }
        if (state2 != null && state2 != state) {
            throw new IllegalArgumentException("This set is in the DFA!");
        }
        this.setToState.put(hashSet, state);
        this.stateToSet.put(state, hashSet);
    }

    public void expandState(State state) {
        ArrayList arrayList = this.converter.expandState(state, this.nfa, this.dfa);
        HashSet hashSet = new HashSet(this.setToState.keySet());
        HashSet hashSet2 = new HashSet();
        for (State state2 : arrayList) {
            this.registerState(state2);
            hashSet.remove(this.stateToSet.get(state2));
        }
        this.layout.layout(this.graph, hashSet);
        for (State state2 : arrayList) {
            Object v = this.stateToSet.get(state2);
            state2.getPoint().setLocation(this.graph.pointForVertex(v));
            state2.setPoint(state2.getPoint());
        }
    }

    public void expandState(State state, Point point, State state2) {
        String string = JOptionPane.showInputDialog(this.view, (Object)"Expand on what terminal?");
        if (string == null) {
            return;
        }
        if (string.equals("")) {
            JOptionPane.showMessageDialog(this.view, "One can't have lambda in the DFA!", "Improper terminal", 0);
            return;
        }
        State[] stateArray = this.getStatesForString(state.getLabel(), this.nfa);
        State[] stateArray2 = this.converter.getStatesOnTerminal(string, stateArray, this.nfa);
        if (stateArray2.length == 0) {
            JOptionPane.showMessageDialog(this.view, "The group {" + state.getLabel() + "} does not expand on the terminal " + string + "!", "Improper expansion", 0);
            return;
        }
        String string2 = "";
        if (state2 == null) {
            string2 = JOptionPane.showInputDialog(this.view, (Object)("Which group of NFA states will that go to on " + string + "?"));
        }
        if (string2 == null) {
            return;
        }
        State[] stateArray3 = stateArray2;
        try {
            if (state2 == null) {
                stateArray3 = this.getStatesForString(string2, this.nfa);
            }
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this.view, "The list of states is not formatted correctly!", "Format error", 0);
            return;
        }
        if (!this.converter.containSameStates(stateArray3, stateArray2)) {
            JOptionPane.showMessageDialog(this.view, "That list of states is incorrect!", "Wrong set", 0);
            return;
        }
        State state3 = this.converter.getStateForStates(stateArray3, this.dfa, this.nfa);
        if (state2 == null) {
            state2 = state3;
        }
        if (state2 != state3) {
            JOptionPane.showMessageDialog(this.view, "The group {" + state.getLabel() + "} does not go to\n" + "group {" + state2.getLabel() + "} on terminal " + string + "!", "Improper transition", 0);
            return;
        }
        if (state2 == null) {
            state2 = this.converter.createStateWithStates(this.dfa, stateArray3, this.nfa);
            this.registerState(state2);
            state2.setPoint(point);
        }
        FSATransition fSATransition = new FSATransition(state, state2, string);
        this.dfa.addTransition(fSATransition);
    }

    public void complete() {
        final LinkedList<State> linkedList = new LinkedList<State>();
        linkedList.addAll(Arrays.asList(this.dfa.getStates()));
        AutomataStateListener automataStateListener = new AutomataStateListener(){

            @Override
            public void automataStateChange(AutomataStateEvent automataStateEvent) {
                if (!automataStateEvent.isAdd()) {
                    return;
                }
                linkedList.addLast(automataStateEvent.getState());
            }
        };
        this.dfa.addStateListener(automataStateListener);
        while (linkedList.size() != 0) {
            this.expandState((State)linkedList.removeFirst());
        }
        this.dfa.removeStateListener(automataStateListener);
    }

    public void done() {
        int n;
        int n2 = this.answer.getStates().length - this.dfa.getStates().length;
        if (n2 + (n = this.answer.getTransitions().length - this.dfa.getTransitions().length) != 0) {
            String string;
            String string2 = n2 == 0 ? "All the states are there.\n" : (string = n2 + " more state" + (n2 == 1 ? "" : "s") + " must be placed.\n");
            String string3 = n == 0 ? "All the transitions are there.\n" : n + " more transition" + (n == 1 ? "" : "s") + " must be placed.\n";
            String string4 = "The DFA has not been completed.\n" + string + string3;
            JOptionPane.showMessageDialog(this.view, string4);
            return;
        }
        JOptionPane.showMessageDialog(this.view, "The DFA is fully built!\nIt will now be placed in a new window.");
        FrameFactory.createFrame((FiniteStateAutomaton)this.dfa.clone());
    }
}

