/*
 * Decompiled with CFR 0.152.
 */
package gui.action;

import automata.AutomatonChecker;
import automata.fsa.FiniteStateAutomaton;
import automata.fsa.Minimizer;
import gui.action.FSAAction;
import gui.environment.Environment;
import gui.environment.Universe;
import gui.environment.tag.CriticalTag;
import gui.minimize.MinimizePane;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;

public class MinimizeTreeAction
extends FSAAction {
    private FiniteStateAutomaton automaton;
    private Environment environment;
    private static Minimizer minimizer = new Minimizer();

    public MinimizeTreeAction(FiniteStateAutomaton finiteStateAutomaton, Environment environment) {
        super("Miniminize DFA", null);
        this.automaton = finiteStateAutomaton;
        this.environment = environment;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.automaton.getInitialState() == null) {
            JOptionPane.showMessageDialog(Universe.frameForEnvironment(this.environment), "The automaton should have an initial state.");
            return;
        }
        AutomatonChecker automatonChecker = new AutomatonChecker();
        if (automatonChecker.isNFA(this.automaton)) {
            JOptionPane.showMessageDialog(Universe.frameForEnvironment(this.environment), "This isn't a DFA!");
            return;
        }
        FiniteStateAutomaton finiteStateAutomaton = (FiniteStateAutomaton)this.automaton.clone();
        MinimizePane minimizePane = new MinimizePane(finiteStateAutomaton, this.environment);
        this.environment.add((Component)minimizePane, "Minimization", new CriticalTag(){});
        this.environment.setActive(minimizePane);
    }
}

