/*
 * Decompiled with CFR 0.152.
 */
package gui.action;

import grammar.CNFConverter;
import grammar.Grammar;
import grammar.LambdaProductionRemover;
import grammar.Production;
import grammar.UnitProductionRemover;
import grammar.UselessProductionRemover;
import gui.action.GrammarAction;
import gui.environment.EnvironmentFrame;
import gui.environment.GrammarEnvironment;
import gui.environment.Universe;
import gui.environment.tag.CriticalTag;
import gui.grammar.transform.ChomskyPane;
import gui.grammar.transform.LambdaPane;
import gui.grammar.transform.UnitPane;
import gui.grammar.transform.UselessPane;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import javax.swing.JOptionPane;

public class GrammarTransformAction
extends GrammarAction {
    private GrammarEnvironment environment;
    private EnvironmentFrame frame;

    public GrammarTransformAction(GrammarEnvironment grammarEnvironment) {
        super("Transform Grammar", null);
        this.environment = grammarEnvironment;
        this.frame = Universe.frameForEnvironment(grammarEnvironment);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Grammar grammar = this.environment.getGrammar();
        if (grammar == null) {
            return;
        }
        GrammarTransformAction.hypothesizeLambda(this.environment, grammar);
    }

    public static void hypothesizeLambda(GrammarEnvironment grammarEnvironment, Grammar grammar) {
        LambdaProductionRemover lambdaProductionRemover = new LambdaProductionRemover();
        HashSet hashSet = lambdaProductionRemover.getCompleteLambdaSet(grammar);
        if (hashSet.contains(grammar.getStartVariable())) {
            JOptionPane.showMessageDialog(grammarEnvironment, "WARNING : The start variable derives lambda.\nNew Grammar will not produce lambda String.", "Start Derives Lambda", 0);
        }
        if (hashSet.size() > 0) {
            LambdaPane lambdaPane = new LambdaPane(grammarEnvironment, grammar);
            grammarEnvironment.add((Component)lambdaPane, "Lambda Removal", new CriticalTag(){});
            grammarEnvironment.setActive(lambdaPane);
            return;
        }
        GrammarTransformAction.hypothesizeUnit(grammarEnvironment, grammar);
    }

    public static void hypothesizeUnit(GrammarEnvironment grammarEnvironment, Grammar grammar) {
        UnitProductionRemover unitProductionRemover = new UnitProductionRemover();
        if (unitProductionRemover.getUnitProductions(grammar).length > 0) {
            UnitPane unitPane = new UnitPane(grammarEnvironment, grammar);
            grammarEnvironment.add((Component)unitPane, "Unit Removal", new CriticalTag(){});
            grammarEnvironment.setActive(unitPane);
            return;
        }
        GrammarTransformAction.hypothesizeUseless(grammarEnvironment, grammar);
    }

    public static void hypothesizeUseless(GrammarEnvironment grammarEnvironment, Grammar grammar) {
        Production[] productionArray;
        UselessProductionRemover uselessProductionRemover = new UselessProductionRemover();
        Grammar grammar2 = UselessProductionRemover.getUselessProductionlessGrammar(grammar);
        Production[] productionArray2 = grammar.getProductions();
        if (productionArray2.length > (productionArray = grammar2.getProductions()).length) {
            UselessPane uselessPane = new UselessPane(grammarEnvironment, grammar);
            grammarEnvironment.add((Component)uselessPane, "Useless Removal", new CriticalTag(){});
            grammarEnvironment.setActive(uselessPane);
            return;
        }
        GrammarTransformAction.hypothesizeChomsky(grammarEnvironment, grammar);
    }

    public static void hypothesizeChomsky(GrammarEnvironment grammarEnvironment, Grammar grammar) {
        CNFConverter cNFConverter = null;
        try {
            cNFConverter = new CNFConverter(grammar);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            JOptionPane.showMessageDialog(grammarEnvironment, illegalArgumentException.getMessage(), "Illegal Grammar", 0);
            return;
        }
        Production[] productionArray = grammar.getProductions();
        boolean bl = true;
        for (int i = 0; i < productionArray.length; ++i) {
            bl &= cNFConverter.isChomsky(productionArray[i]);
        }
        if (bl) {
            JOptionPane.showMessageDialog(grammarEnvironment, "The grammar is already in Chomsky NF.", "Already in CNF", 0);
            return;
        }
        ChomskyPane chomskyPane = new ChomskyPane(grammarEnvironment, grammar);
        grammarEnvironment.add((Component)chomskyPane, "Chomsky Converter", new CriticalTag(){});
        grammarEnvironment.setActive(chomskyPane);
    }
}

