/*
 * Decompiled with CFR 0.152.
 */
package gui.action;

import gui.action.RestrictedAction;
import gui.environment.Environment;
import gui.environment.Universe;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.swing.svg.SVGFileFilter;
import org.w3c.dom.Document;

public class ExportAction
extends RestrictedAction {
    private Environment environment;

    public ExportAction(Environment environment) {
        super("Export to SVG", null);
        this.environment = environment;
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(69, MAIN_MENU_MASK));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JComponent jComponent = (JComponent)this.environment.getActive();
        SVGDOMImplementation sVGDOMImplementation = (SVGDOMImplementation)SVGDOMImplementation.getDOMImplementation();
        String string = "http://www.w3.org/2000/svg";
        Document document = sVGDOMImplementation.createDocument(string, "svg", null);
        SVGGeneratorContext sVGGeneratorContext = SVGGeneratorContext.createDefault(document);
        sVGGeneratorContext.setComment("Generated by JFLAP using Batik SVG Generator");
        sVGGeneratorContext.setEmbeddedFontsOn(true);
        SVGGraphics2D sVGGraphics2D = new SVGGraphics2D(sVGGeneratorContext, false);
        jComponent.print(sVGGraphics2D);
        Universe.CHOOSER.resetChoosableFileFilters();
        Universe.CHOOSER.setAcceptAllFileFilterUsed(false);
        Universe.CHOOSER.addChoosableFileFilter(new SVGFileFilter());
        int n = Universe.CHOOSER.showSaveDialog(jComponent);
        while (n == 0) {
            int n2;
            File file = Universe.CHOOSER.getSelectedFile();
            if (!new SVGFileFilter().accept(file)) {
                file = new File(file.getAbsolutePath() + ".svg");
            }
            if (file.exists() && (n2 = JOptionPane.showConfirmDialog(Universe.CHOOSER, "File exists. Shall I overwrite?", "FILE OVERWRITE ATTEMPTED", 0)) == 1) {
                n = Universe.CHOOSER.showSaveDialog(jComponent);
                continue;
            }
            try {
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
                sVGGraphics2D.stream(outputStreamWriter, true);
                return;
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(jComponent, "Export failed with error:\n" + iOException.getMessage(), "Export failed", 0);
                return;
            }
        }
    }
}

