/*
 * Decompiled with CFR 0.152.
 */
package gui.action;

import automata.UselessStatesDetector;
import automata.fsa.FiniteStateAutomaton;
import automata.graph.FSAEqualityChecker;
import gui.action.FSAAction;
import gui.environment.Environment;
import gui.environment.EnvironmentFrame;
import gui.environment.Universe;
import java.awt.event.ActionEvent;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;

public class DFAEqualityAction
extends FSAAction {
    private Environment environment;
    private static FSAEqualityChecker checker = new FSAEqualityChecker();

    public DFAEqualityAction(FiniteStateAutomaton finiteStateAutomaton, Environment environment) {
        super("Compare Equivalence", null);
        this.environment = environment;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JComboBox<EnvironmentFrame> jComboBox = new JComboBox<EnvironmentFrame>();
        EnvironmentFrame[] environmentFrameArray = Universe.frames();
        for (int i = 0; i < environmentFrameArray.length; ++i) {
            if (!DFAEqualityAction.isApplicable(environmentFrameArray[i].getEnvironment().getObject()) || environmentFrameArray[i].getEnvironment() == this.environment) continue;
            jComboBox.addItem(environmentFrameArray[i]);
        }
        FiniteStateAutomaton finiteStateAutomaton = (FiniteStateAutomaton)this.environment.getObject();
        if (jComboBox.getItemCount() == 0) {
            JOptionPane.showMessageDialog(Universe.frameForEnvironment(this.environment), "No other FAs around!");
            return;
        }
        if (finiteStateAutomaton.getInitialState() == null) {
            JOptionPane.showMessageDialog(Universe.frameForEnvironment(this.environment), "This automaton has no initial state!");
            return;
        }
        int n = JOptionPane.showOptionDialog(Universe.frameForEnvironment(this.environment), jComboBox, "Compare against FA", 2, 3, null, null, null);
        if (n != 0 && n != 0) {
            return;
        }
        FiniteStateAutomaton finiteStateAutomaton2 = (FiniteStateAutomaton)((EnvironmentFrame)jComboBox.getSelectedItem()).getEnvironment().getObject();
        if (finiteStateAutomaton2.getInitialState() == null) {
            JOptionPane.showMessageDialog(Universe.frameForEnvironment(this.environment), "The other automaton has no initial state!");
            return;
        }
        String string = checker.equals(finiteStateAutomaton2 = (FiniteStateAutomaton)UselessStatesDetector.cleanAutomaton(finiteStateAutomaton2), finiteStateAutomaton = (FiniteStateAutomaton)UselessStatesDetector.cleanAutomaton(finiteStateAutomaton)) ? "They ARE equivalent!" : "They AREN'T equivalent!";
        JOptionPane.showMessageDialog(Universe.frameForEnvironment(this.environment), string);
    }
}

