/*
 * Decompiled with CFR 0.152.
 */
package gui.action;

import automata.Transition;
import automata.fsa.FiniteStateAutomaton;
import automata.graph.AutomatonGraph;
import automata.graph.LayoutAlgorithm;
import automata.graph.layout.GEMLayoutAlgorithm;
import grammar.Production;
import grammar.reg.RightLinearGrammar;
import grammar.reg.RightLinearGrammarToFSAConverter;
import gui.action.GrammarAction;
import gui.environment.GrammarEnvironment;
import gui.environment.Universe;
import gui.environment.tag.CriticalTag;
import gui.grammar.convert.ConvertPane;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import javax.swing.JOptionPane;

public class ConvertRegularGrammarToFSA
extends GrammarAction {
    private GrammarEnvironment environment;

    public ConvertRegularGrammarToFSA(GrammarEnvironment grammarEnvironment) {
        super("Convert Right-Linear Grammar to FA", null);
        this.environment = grammarEnvironment;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Cloneable cloneable;
        RightLinearGrammar rightLinearGrammar = (RightLinearGrammar)this.environment.getGrammar(RightLinearGrammar.class);
        if (rightLinearGrammar == null) {
            return;
        }
        if (rightLinearGrammar.getProductions().length == 0) {
            JOptionPane.showMessageDialog(Universe.frameForEnvironment(this.environment), "The grammar should exist.");
            return;
        }
        FiniteStateAutomaton finiteStateAutomaton = new FiniteStateAutomaton();
        RightLinearGrammarToFSAConverter rightLinearGrammarToFSAConverter = new RightLinearGrammarToFSAConverter();
        rightLinearGrammarToFSAConverter.createStatesForConversion(rightLinearGrammar, finiteStateAutomaton);
        AutomatonGraph automatonGraph = new AutomatonGraph(finiteStateAutomaton);
        HashMap<Production, Transition> hashMap = new HashMap<Production, Transition>();
        Production[] productionArray = rightLinearGrammar.getProductions();
        for (int i = 0; i < productionArray.length; ++i) {
            cloneable = rightLinearGrammarToFSAConverter.getTransitionForProduction(productionArray[i]);
            automatonGraph.addEdge(cloneable.getFromState(), cloneable.getToState());
            hashMap.put(productionArray[i], (Transition)cloneable);
        }
        ConvertPane convertPane = new ConvertPane(rightLinearGrammar, finiteStateAutomaton, hashMap, this.environment);
        this.environment.add((Component)convertPane, "Convert to FA", new CriticalTag(){});
        cloneable = convertPane.getEditorPane().getAutomatonPane().getVisibleRect();
        GEMLayoutAlgorithm gEMLayoutAlgorithm = new GEMLayoutAlgorithm();
        ((LayoutAlgorithm)gEMLayoutAlgorithm).layout(automatonGraph, null);
        automatonGraph.moveAutomatonStates();
        this.environment.setActive(convertPane);
        this.environment.validate();
        convertPane.getEditorPane().getAutomatonPane().fitToBounds(20);
    }
}

