/*
 * Decompiled with CFR 0.152.
 */
package gui.action;

import automata.Automaton;
import automata.State;
import automata.Transition;
import automata.mealy.MooreMachine;
import automata.turing.TuringMachine;
import gui.action.AutomatonAction;
import gui.environment.AutomatonEnvironment;
import gui.environment.Environment;
import gui.environment.EnvironmentFrame;
import gui.environment.FrameFactory;
import gui.environment.Universe;
import gui.viewer.AutomatonDrawer;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.HashMap;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;

public class CombineAutomaton
extends AutomatonAction {
    private AutomatonEnvironment environment;

    public CombineAutomaton(AutomatonEnvironment automatonEnvironment) {
        super("Combine Automata", null);
        this.environment = automatonEnvironment;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Automaton automaton;
        Serializable serializable;
        int n;
        JComboBox<EnvironmentFrame> jComboBox = new JComboBox<EnvironmentFrame>();
        EnvironmentFrame[] environmentFrameArray = Universe.frames();
        for (n = 0; n < environmentFrameArray.length; ++n) {
            serializable = environmentFrameArray[n].getEnvironment();
            if (serializable == this.environment || !(serializable instanceof AutomatonEnvironment) || this.environment.getObject().getClass() != ((Environment)serializable).getObject().getClass()) continue;
            if (this.environment.getObject() instanceof TuringMachine) {
                automaton = (TuringMachine)this.environment.getObject();
                TuringMachine turingMachine = (TuringMachine)((Environment)serializable).getObject();
                if (((TuringMachine)automaton).tapes() != turingMachine.tapes()) continue;
            }
            jComboBox.addItem(environmentFrameArray[n]);
        }
        if (jComboBox.getItemCount() == 0) {
            JOptionPane.showMessageDialog(Universe.frameForEnvironment(this.environment), "No other automatons of this type around!");
            return;
        }
        n = JOptionPane.showOptionDialog(Universe.frameForEnvironment(this.environment), jComboBox, "Combine Two", 2, 3, null, null, null);
        if (n != 0 && n != 0) {
            return;
        }
        serializable = (Automaton)((EnvironmentFrame)jComboBox.getSelectedItem()).getEnvironment().getObject();
        automaton = (Automaton)this.environment.getAutomaton().clone();
        this.add(automaton, (Automaton)serializable);
        FrameFactory.createFrame(automaton);
    }

    private void add(Automaton automaton, Automaton automaton2) {
        Serializable serializable;
        State state;
        Cloneable cloneable;
        AutomatonDrawer automatonDrawer = new AutomatonDrawer(automaton);
        AutomatonDrawer automatonDrawer2 = new AutomatonDrawer(automaton2);
        Rectangle2D rectangle2D = automatonDrawer.getBounds();
        Rectangle2D rectangle2D2 = automatonDrawer2.getBounds();
        if (rectangle2D == null) {
            rectangle2D = new Rectangle2D.Float();
        }
        if (rectangle2D2 == null) {
            rectangle2D2 = new Rectangle2D.Float();
        }
        double d = rectangle2D.getY() + rectangle2D.getHeight() - rectangle2D2.getY() + 20.0;
        State[] stateArray = automaton2.getStates();
        HashMap<State, State> hashMap = new HashMap<State, State>();
        for (int i = 0; i < stateArray.length; ++i) {
            State state2 = stateArray[i];
            cloneable = new Point(state2.getPoint().x, state2.getPoint().y + (int)d);
            state = automaton.createState((Point)cloneable);
            if (automaton2.isFinalState(state2)) {
                automaton.addFinalState(state);
            }
            state.setLabel(state2.getLabel());
            if (automaton instanceof MooreMachine && automaton2 instanceof MooreMachine) {
                serializable = (MooreMachine)automaton;
                MooreMachine mooreMachine = (MooreMachine)automaton2;
                ((MooreMachine)serializable).setOutput(state, mooreMachine.getOutput(state2));
            }
            hashMap.put(state2, state);
        }
        Transition[] transitionArray = automaton2.getTransitions();
        for (int i = 0; i < transitionArray.length; ++i) {
            cloneable = transitionArray[i];
            state = (State)hashMap.get(((Transition)cloneable).getFromState());
            serializable = (State)hashMap.get(((Transition)cloneable).getToState());
            automaton.addTransition(((Transition)cloneable).copy(state, (State)serializable));
        }
    }
}

