/*
 * Decompiled with CFR 0.152.
 */
package gui;

import file.Codec;
import file.ParseException;
import gui.ThrowableCatcher;
import gui.action.NewAction;
import gui.action.OpenAction;
import gui.environment.Profile;
import gui.environment.Universe;
import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class Main {
    private static boolean dontQuit;

    public static boolean getDontQuit() {
        return dontQuit;
    }

    public static void main(String[] stringArray, boolean bl) {
        dontQuit = bl;
        try {
            String string = System.getProperty("java.specification.version");
            double d = Double.parseDouble(string) + 1.0E-5;
            if (d < 1.5) {
                JOptionPane.showMessageDialog(null, "Java 1.5 or higher required to run JFLAP!\nYou appear to be running Java " + string + ".\n" + "This program will now exit.");
                System.exit(0);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            if (ThrowableCatcher.class == null) {
                // empty if block
            }
            System.setProperty("sun.awt.exception.handler", "gui.ThrowableCatcher");
        }
        catch (SecurityException securityException) {
            System.err.println("Warning: could not set the AWT exception handler.");
        }
        try {
            if (System.getProperty("os.name").startsWith("Mac OS") && System.getProperty("java.specification.version").equals("1.3")) {
                System.setProperty("com.apple.hwaccel", "false");
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            System.setProperty("java.util.prefs.syncInterval", "2000000");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        NewAction.showNew();
        if (stringArray.length > 0) {
            if (stringArray[0].equals("text")) {
                // empty if block
            }
            for (int i = 0; i < stringArray.length; ++i) {
                Codec[] codecArray = Universe.CODEC_REGISTRY.getDecoders().toArray(new Codec[0]);
                try {
                    OpenAction.openFile(new File(stringArray[i]), codecArray);
                    continue;
                }
                catch (ParseException parseException) {
                    System.err.println("Could not open " + stringArray[i] + ": " + parseException.getMessage());
                }
            }
        }
        Main.loadPreferences();
    }

    private static void loadPreferences() {
        Profile profile = Universe.curProfile;
        String string = "";
        try {
            string = new File(".").getCanonicalPath();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        profile.pathToFile = string = string + "/jflapPreferences.xml";
        if (new File(string).exists()) {
            File file = new File(string);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                try {
                    String string2;
                    Document document = documentBuilder.parse(file);
                    Node node = document.getDocumentElement().getElementsByTagName(profile.EMPTY_STRING_NAME).item(0);
                    if (node != null) {
                        string2 = node.getTextContent();
                        if (string2.equals(profile.lambdaText)) {
                            profile.setEmptyString(profile.lambda);
                        } else if (string2.equals(profile.epsilonText)) {
                            profile.setEmptyString(profile.epsilon);
                        }
                    }
                    if ((node = document.getDocumentElement().getElementsByTagName("turing_final").item(0)) != null) {
                        string2 = node.getTextContent();
                        if (string2.equals("true")) {
                            profile.setTransitionsFromTuringFinalStateAllowed(true);
                        } else {
                            profile.setTransitionsFromTuringFinalStateAllowed(false);
                        }
                    }
                    if ((node = document.getDocumentElement().getElementsByTagName("turing_accept_by_final_state").item(0)) != null) {
                        string2 = node.getTextContent();
                        if (string2.equals("true")) {
                            profile.setAcceptByFinalState(true);
                        } else {
                            profile.setAcceptByFinalState(false);
                        }
                    }
                    if ((node = document.getDocumentElement().getElementsByTagName("turing_accept_by_halt").item(0)) != null) {
                        string2 = node.getTextContent();
                        if (string2.equals("true")) {
                            profile.setAcceptByHalting(true);
                        } else {
                            profile.setAcceptByHalting(false);
                        }
                    }
                    if ((node = document.getDocumentElement().getElementsByTagName("turing_allow_stay_on_transition").item(0)) != null) {
                        string2 = node.getTextContent();
                        if (string2.equals("true")) {
                            profile.setAllowStay(true);
                        } else {
                            profile.setAllowStay(false);
                        }
                    }
                    if ((node = document.getDocumentElement().getElementsByTagName("undo_amount").item(0)) != null) {
                        string2 = node.getTextContent();
                        profile.setNumUndo(Integer.parseInt(string2));
                    }
                }
                catch (SAXException sAXException) {
                    sAXException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            catch (ParserConfigurationException parserConfigurationException) {
                parserConfigurationException.printStackTrace();
            }
        }
    }
}

