/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class HighlightTable
extends JTable {
    private static TableHighlighterRendererGenerator THRG = new TableHighlighterRendererGenerator(){
        private DefaultTableCellRenderer renderer = null;

        @Override
        public TableCellRenderer getRenderer(int n, int n2) {
            if (this.renderer == null) {
                this.renderer = new DefaultTableCellRenderer();
                this.renderer.setBackground(new Color(255, 150, 150));
            }
            return this.renderer;
        }
    };
    private Map highlightRenderers = new HashMap();

    public HighlightTable() {
    }

    public HighlightTable(TableModel tableModel) {
        super(tableModel);
    }

    public void highlight(int n, int n2) {
        this.highlight(n, n2, THRG);
    }

    private static int singleIndex(int n, int n2) {
        return n + (n2 << 22);
    }

    public void dehighlight(int n, int n2) {
        this.highlightRenderers.remove(new Integer(HighlightTable.singleIndex(n, n2)));
        this.repaint();
    }

    public void highlight(int[][] nArray, TableHighlighterRendererGenerator tableHighlighterRendererGenerator) {
        this.highlightRenderers = new HashMap();
        for (int i = 0; i < nArray.length; ++i) {
            this.highlight(nArray[i][0], nArray[i][1], tableHighlighterRendererGenerator);
        }
    }

    public void highlight(int n, int n2, TableHighlighterRendererGenerator tableHighlighterRendererGenerator) {
        if (this.highlightRenderers == null) {
            this.highlightRenderers = new HashMap();
        }
        Integer n3 = new Integer(HighlightTable.singleIndex(n, n2));
        this.highlightRenderers.put(n3, tableHighlighterRendererGenerator.getRenderer(n, n2));
        this.repaint();
    }

    public void dehighlight() {
        this.highlightRenderers = null;
        this.repaint();
    }

    @Override
    public TableCellRenderer getCellRenderer(int n, int n2) {
        TableCellRenderer tableCellRenderer;
        int n3 = this.convertColumnIndexToModel(n2);
        if (this.highlightRenderers != null && (tableCellRenderer = (TableCellRenderer)this.highlightRenderers.get(new Integer(HighlightTable.singleIndex(n, n3)))) != null) {
            return tableCellRenderer;
        }
        return super.getCellRenderer(n, n2);
    }

    public static interface TableHighlighterRendererGenerator {
        public TableCellRenderer getRenderer(int var1, int var2);
    }
}

