/*
 * Decompiled with CFR 0.152.
 */
package grammar.parse;

import grammar.Grammar;
import grammar.Production;
import grammar.parse.ParseNode;
import grammar.parse.RestrictedUserParser;
import grammar.parse.Unrestricted;
import grammar.parse.UnrestrictedUserParser;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Set;

public abstract class UserParser {
    private static final Production[] P = new Production[0];
    private static final int[] S = new int[0];
    private static final ParseNode E = new ParseNode("", P, S);
    protected Grammar myGrammar;
    protected Production[] myProductions;
    protected String myTarget;
    private boolean isDone = false;
    private ParseNode myAnswer;
    protected Set mySmallerSet;
    private Production myCurrentProduction;
    private int myCount = 0;
    private LinkedList myQueue = new LinkedList();

    public UserParser(Grammar grammar, String string) {
        this.initialize(grammar, string);
    }

    private void initialize(Grammar grammar, String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (grammar.isTerminal(string.substring(i, i + 1))) continue;
            throw new IllegalArgumentException("String to parse has nonterminal " + string.substring(i, i + 1) + ".");
        }
        if (grammar == null) {
            return;
        }
        this.myQueue.clear();
        this.myAnswer = new ParseNode(grammar.getStartVariable(), P, S);
        this.myQueue.add(this.myAnswer);
        this.mySmallerSet = Collections.unmodifiableSet(Unrestricted.smallerSymbols(grammar));
        this.myGrammar = grammar;
        this.myProductions = grammar.getProductions();
        this.myTarget = string;
    }

    public static UserParser get(Grammar grammar, String string) {
        if (Unrestricted.isUnrestricted(grammar)) {
            return new UnrestrictedUserParser(grammar, string);
        }
        return new RestrictedUserParser(grammar, string);
    }

    public int checkValidAndParse(int n) {
        this.myCurrentProduction = this.myProductions[n];
        int n2 = this.myCurrentProduction.getLHS().length();
        int n3 = 0;
        for (int i = 0; i < this.myAnswer.getDerivation().length() && i + n2 <= this.myAnswer.getDerivation().length(); ++i) {
            if (!this.myAnswer.getDerivation().substring(i, i + n2).equals(this.myCurrentProduction.getLHS())) continue;
            ++n3;
        }
        return n3;
    }

    private ParseNode getNextResult(String string, int n) {
        if (string.length() == 0) {
            return E;
        }
        int n2 = 0;
        if (n < 0) {
            n = string.indexOf(this.myCurrentProduction.getLHS());
        }
        n2 = n;
        String string2 = string.substring(0, n2) + this.myCurrentProduction.getRHS() + string.substring(n2 + this.myCurrentProduction.getLHS().length());
        Production[] productionArray = new Production[]{this.myCurrentProduction};
        int[] nArray = new int[]{n2};
        return new ParseNode(string2, productionArray, nArray);
    }

    public boolean isPossibleDerivation(String string) {
        return Unrestricted.minimumLength(string, this.mySmallerSet) <= this.myTarget.length();
    }

    public synchronized void parse(int n) {
        if (this.myCount == 0) {
            ++this.myCount;
            return;
        }
        ParseNode parseNode = (ParseNode)this.myQueue.removeFirst();
        ParseNode parseNode2 = this.getNextResult(this.myAnswer.getDerivation(), n);
        parseNode2 = new ParseNode(parseNode2);
        parseNode.add(parseNode2);
        this.myQueue.add(parseNode2);
        this.myAnswer = parseNode2;
        if (parseNode2.getDerivation().equals(this.myTarget)) {
            this.isDone = true;
            return;
        }
        this.isDone = false;
    }

    public synchronized boolean start() {
        if (this.isFinished()) {
            return false;
        }
        this.parse(-1);
        return true;
    }

    public synchronized boolean isFinished() {
        return this.isDone;
    }

    public synchronized ParseNode getAnswer() {
        return this.myAnswer;
    }

    public synchronized ParseNode getPreviousAnswer() {
        this.myAnswer = (ParseNode)this.myAnswer.getParent();
        this.myQueue.clear();
        this.myQueue.add(this.myAnswer);
        return this.myAnswer;
    }

    public String getLHSForProduction(int n) {
        return this.myProductions[n].getLHS();
    }

    public void subsitute(int[] nArray) {
        ParseNode parseNode = (ParseNode)this.myQueue.removeFirst();
        ParseNode parseNode2 = this.getNextSubstitution(this.myAnswer.getDerivation(), nArray);
        parseNode2 = new ParseNode(parseNode2);
        parseNode.add(parseNode2);
        this.myQueue.add(parseNode2);
        this.myAnswer = parseNode2;
        if (parseNode2.getDerivation().equals(this.myTarget)) {
            this.isDone = true;
            return;
        }
        this.isDone = false;
    }

    private ParseNode getNextSubstitution(String string, int[] nArray) {
        int[] nArray2 = nArray;
        int n = 0;
        String string2 = "";
        Production[] productionArray = new Production[nArray2.length];
        productionArray[0] = this.myCurrentProduction;
        for (int i = 0; i < nArray2.length; ++i) {
            n = i == 0 ? nArray2[i] : nArray2[i] + i * (this.myCurrentProduction.getRHS().length() - 1);
            string = string2 = string.substring(0, n) + this.myCurrentProduction.getRHS() + string.substring(n + this.myCurrentProduction.getLHS().length());
            productionArray[i] = this.myCurrentProduction;
        }
        return new ParseNode(string2, productionArray, nArray2);
    }

    public boolean isStringTerminal(String string) {
        for (int i = 0; i < this.myProductions.length; ++i) {
            if (!string.contains(this.myProductions[i].getLHS())) continue;
            return false;
        }
        return true;
    }
}

