/*
 * Decompiled with CFR 0.152.
 */
package grammar.parse;

import grammar.Grammar;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.table.AbstractTableModel;

public class LLParseTable
extends AbstractTableModel
implements Serializable,
Cloneable {
    private String[] terminals;
    private String[] variables;
    private SortedSet[][] entries;
    private boolean frozen = false;

    public LLParseTable(Grammar grammar) {
        this.variables = grammar.getVariables();
        Arrays.sort(this.variables);
        this.terminals = grammar.getTerminals();
        Arrays.sort(this.terminals);
        this.entries = new SortedSet[this.variables.length][this.terminals.length + 1];
        for (int i = 0; i < this.entries.length; ++i) {
            for (int j = 0; j < this.entries[i].length; ++j) {
                this.entries[i][j] = new TreeSet();
            }
        }
    }

    public LLParseTable(LLParseTable lLParseTable) {
        this.variables = lLParseTable.variables;
        this.terminals = lLParseTable.terminals;
        this.entries = new SortedSet[this.variables.length][this.terminals.length + 1];
        for (int i = 0; i < this.entries.length; ++i) {
            for (int j = 0; j < this.entries[i].length; ++j) {
                this.entries[i][j] = new TreeSet(lLParseTable.entries[i][j]);
            }
        }
    }

    public Object clone() {
        return new LLParseTable(this);
    }

    public boolean equals(Object object) {
        try {
            LLParseTable lLParseTable = (LLParseTable)object;
            if (!Arrays.equals(this.variables, lLParseTable.variables)) {
                return false;
            }
            if (!Arrays.equals(this.terminals, lLParseTable.terminals)) {
                return false;
            }
            for (int i = 0; i < this.variables.length; ++i) {
                if (Arrays.equals(this.entries[i], lLParseTable.entries[i])) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        return this.variables.length ^ this.terminals.length;
    }

    private int[] getLocation(String string, String string2) {
        int[] nArray = new int[]{this.getRow(string), this.getColumn(string2) - 1};
        return nArray;
    }

    public int getRow(String string) {
        int n = Arrays.binarySearch(this.variables, string);
        if (n < 0) {
            throw new IllegalArgumentException(string + " is not a variable!");
        }
        return n;
    }

    public int getColumn(String string) {
        int n = this.terminals.length;
        if (!string.equals("$")) {
            n = Arrays.binarySearch(this.terminals, string);
        }
        if (n < 0) {
            throw new IllegalArgumentException(string + " is not a terminal!");
        }
        return n + 1;
    }

    public String[][] getDifferences(LLParseTable lLParseTable) {
        if (!Arrays.equals(this.variables, lLParseTable.variables) || !Arrays.equals(this.terminals, lLParseTable.terminals)) {
            throw new IllegalArgumentException("Tables differ in variables or terminals.");
        }
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        for (int i = 0; i < this.entries.length; ++i) {
            for (int j = 0; j < this.entries[i].length; ++j) {
                if (this.entries[i][j].equals(lLParseTable.entries[i][j])) continue;
                if (j == this.terminals.length) {
                    arrayList.add(new String[]{this.variables[i], "$"});
                    continue;
                }
                arrayList.add(new String[]{this.variables[i], this.terminals[j]});
            }
        }
        return (String[][])arrayList.toArray((T[])new String[0][0]);
    }

    public int addEntry(String string, String string2, String string3) {
        int[] nArray = this.getLocation(string, string2);
        this.entries[nArray[0]][nArray[1]].add(string3);
        this.fireTableCellUpdated(nArray[0], nArray[1] + 1);
        return this.entries[nArray[0]][nArray[1]].size();
    }

    public boolean removeEntry(String string, String string2, String string3) {
        int[] nArray = this.getLocation(string, string2);
        boolean bl = this.entries[nArray[0]][nArray[1]].remove(string3);
        this.fireTableCellUpdated(nArray[0], nArray[1] + 1);
        return bl;
    }

    public void clear() {
        for (int i = 0; i < this.entries.length; ++i) {
            for (int j = 0; j < this.entries[i].length; ++j) {
                this.entries[i][j].clear();
            }
        }
        this.fireTableDataChanged();
    }

    public void clear(String string, String string2) {
        int[] nArray = this.getLocation(string, string2);
        this.entries[nArray[0]][nArray[1]].clear();
        this.fireTableCellUpdated(nArray[0], nArray[1] + 1);
    }

    public SortedSet get(String string, String string2) {
        int[] nArray = this.getLocation(string, string2);
        return Collections.unmodifiableSortedSet(this.entries[nArray[0]][nArray[1]]);
    }

    public void set(Set set, String string, String string2) {
        int[] nArray = this.getLocation(string, string2);
        this.entries[nArray[0]][nArray[1]].clear();
        this.entries[nArray[0]][nArray[1]].addAll(set);
    }

    @Override
    public int getRowCount() {
        return this.variables.length;
    }

    @Override
    public int getColumnCount() {
        return this.terminals.length + 2;
    }

    @Override
    public String getColumnName(int n) {
        if (n == 0) {
            return " ";
        }
        if (n == this.terminals.length + 1) {
            return "$";
        }
        return this.terminals[n - 1];
    }

    private String spaceSet(Set set) {
        Iterator iterator = set.iterator();
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            String string;
            if (!bl) {
                stringBuffer.append(" ");
            }
            stringBuffer.append((string = (String)iterator.next()).equals("") ? "!" : string);
            bl = false;
        }
        return stringBuffer.toString();
    }

    private int despaceSet(String string, Set set) {
        set.clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("!")) {
                string2 = "";
            }
            set.add(string2);
        }
        return set.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n2 == 0) {
            return this.variables[n];
        }
        return this.spaceSet(this.entries[n][n2 - 1]);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        this.despaceSet((String)object, this.entries[n][n2 - 1]);
        this.fireTableCellUpdated(n, n2);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (this.frozen) {
            return false;
        }
        return n2 != 0;
    }

    public void setEditable(boolean bl) {
        this.frozen = !bl;
    }
}

