/*
 * Decompiled with CFR 0.152.
 */
package grammar.parse;

import grammar.Grammar;
import grammar.Production;
import grammar.parse.BruteParserEvent;
import grammar.parse.BruteParserListener;
import grammar.parse.ParseNode;
import grammar.parse.RestrictedBruteParser;
import grammar.parse.Unrestricted;
import grammar.parse.UnrestrictedBruteParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class BruteParser {
    private static final Production[] P = new Production[0];
    private static final int[] S = new int[0];
    private static final ParseNode E = new ParseNode("", P, S);
    protected Set listeners = new HashSet();
    protected Grammar grammar;
    protected Production[] productions;
    protected String target;
    private boolean isDone = false;
    private Thread parseThread = null;
    private Set alreadyAdded = new HashSet();
    private Map prederived = new HashMap();
    protected LinkedList queue = new LinkedList();
    private int consideredNodes = 0;
    private int beingConsideredNodes = 0;
    private int deletedNodes = 0;
    private ParseNode answer = null;
    protected Set smaller;

    protected BruteParser() {
    }

    public BruteParser(Grammar grammar, String string) {
        this.init(grammar, string);
    }

    public static BruteParser get(Grammar grammar, String string) {
        if (Unrestricted.isUnrestricted(grammar)) {
            return new UnrestrictedBruteParser(grammar, string);
        }
        return new RestrictedBruteParser(grammar, string);
    }

    protected void init(Grammar grammar, String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (grammar.isTerminal(string.substring(i, i + 1))) continue;
            throw new IllegalArgumentException("String to parse has nonterminal " + string.substring(i, i + 1) + ".");
        }
        this.queue.clear();
        grammar = Unrestricted.optimize(grammar);
        if (grammar == null) {
            return;
        }
        this.queue.add(new ParseNode(grammar.getStartVariable(), P, S));
        this.consideredNodes = 0;
        this.deletedNodes = 0;
        this.smaller = Collections.unmodifiableSet(Unrestricted.smallerSymbols(grammar));
        this.grammar = grammar;
        this.productions = grammar.getProductions();
        this.target = string;
    }

    public synchronized boolean start() {
        if (this.isActive() || this.isFinished()) {
            return false;
        }
        this.parseThread = new Thread(){

            @Override
            public void run() {
                while (BruteParser.this.parseThread != null) {
                    BruteParser.this.parse();
                }
            }
        };
        this.parseThread.start();
        this.distributeEvent(new BruteParserEvent(this, 0));
        return true;
    }

    public synchronized void pause() {
        this.parseThread = null;
        this.distributeEvent(new BruteParserEvent(this, 1));
    }

    public synchronized boolean isActive() {
        return this.parseThread != null;
    }

    public synchronized boolean isFinished() {
        return this.isDone;
    }

    public synchronized ParseNode getAnswer() {
        return this.answer;
    }

    private List getPossibilities(String string) {
        ArrayList<ParseNode> arrayList = new ArrayList<ParseNode>();
        if (this.prederived.containsKey(string)) {
            return (List)this.prederived.get(string);
        }
        HashSet<String> hashSet = new HashSet<String>();
        if (string.length() == 0) {
            arrayList.add(E);
            return arrayList;
        }
        for (int i = -1; i < this.productions.length; ++i) {
            Production production = i == -1 ? new Production(string.substring(0, 1), string.substring(0, 1)) : this.productions[i];
            int n = string.indexOf(production.getLHS());
            int n2 = production.getLHS().length();
            if (n == -1) continue;
            List list = this.getPossibilities(string.substring(n + n2));
            Iterator iterator = list.iterator();
            String string2 = string.substring(0, n) + production.getRHS();
            int n3 = n + production.getLHS().length();
            while (iterator.hasNext()) {
                Object[] objectArray;
                ParseNode parseNode = (ParseNode)iterator.next();
                String string3 = parseNode.getDerivation();
                Production[] productionArray = parseNode.getProductions();
                String string4 = string2 + string3;
                int[] nArray = parseNode.getSubstitutions();
                if (i == -1) {
                    objectArray = new int[nArray.length];
                    for (int j = 0; j < productionArray.length; ++j) {
                        objectArray[j] = nArray[j] + n3;
                    }
                    if (!hashSet.add(string4)) continue;
                    parseNode = new ParseNode(string4, productionArray, (int[])objectArray);
                    arrayList.add(parseNode);
                    ++this.beingConsideredNodes;
                    continue;
                }
                objectArray = new Production[productionArray.length + 1];
                int[] nArray2 = new int[nArray.length + 1];
                nArray2[0] = n;
                objectArray[0] = (int)production;
                for (int j = 0; j < productionArray.length; ++j) {
                    objectArray[j + 1] = (int)productionArray[j];
                    nArray2[j + 1] = nArray[j] + n3;
                }
                if (!hashSet.add(string4)) continue;
                parseNode = new ParseNode(string4, (Production[])objectArray, nArray2);
                arrayList.add(parseNode);
                ++this.beingConsideredNodes;
            }
        }
        return arrayList;
    }

    private void removeFutility(ParseNode parseNode) {
        try {
            while (parseNode.isLeaf()) {
                ((ParseNode)parseNode.getParent()).remove(parseNode);
                ++this.deletedNodes;
                parseNode = (ParseNode)parseNode.getParent();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public int getCurrentNodeCount() {
        return this.consideredNodes - this.deletedNodes;
    }

    public int getTotalNodeCount() {
        return this.consideredNodes;
    }

    public int getConsiderationNodeCount() {
        return this.beingConsideredNodes;
    }

    public boolean isPossibleDerivation(String string) {
        return Unrestricted.minimumLength(string, this.smaller) <= this.target.length();
    }

    private synchronized void parse() {
        if (this.queue.isEmpty()) {
            this.isDone = true;
            this.parseThread = null;
            this.distributeEvent(new BruteParserEvent(this, 3));
            return;
        }
        ParseNode parseNode = (ParseNode)this.queue.removeFirst();
        this.beingConsideredNodes = 0;
        List list = this.getPossibilities(parseNode.getDerivation());
        this.beingConsideredNodes = 0;
        for (ParseNode parseNode2 : list) {
            if (!this.alreadyAdded.add(parseNode2.getDerivation()) || !this.isPossibleDerivation(parseNode2.getDerivation())) continue;
            parseNode2 = new ParseNode(parseNode2);
            parseNode.add(parseNode2);
            this.queue.add(parseNode2);
            ++this.consideredNodes;
            if (!parseNode2.getDerivation().equals(this.target)) continue;
            this.answer = parseNode2;
            this.isDone = true;
            this.parseThread = null;
            this.queue.clear();
            this.distributeEvent(new BruteParserEvent(this, 2));
            return;
        }
        if (parseNode.isLeaf()) {
            this.removeFutility(parseNode);
        }
    }

    public void addBruteParserListener(BruteParserListener bruteParserListener) {
        this.listeners.add(bruteParserListener);
    }

    public void removeBruteParserListener(BruteParserListener bruteParserListener) {
        this.listeners.remove(bruteParserListener);
    }

    protected void distributeEvent(BruteParserEvent bruteParserEvent) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((BruteParserListener)iterator.next()).bruteParserStateChange(bruteParserEvent);
        }
    }
}

