/*
 * Decompiled with CFR 0.152.
 */
package grammar;

import automata.State;
import automata.Transition;
import automata.UnreachableStatesDetector;
import automata.vdg.VDGTransition;
import automata.vdg.VariableDependencyGraph;
import grammar.Grammar;
import grammar.GrammarChecker;
import grammar.Production;
import grammar.ProductionChecker;
import grammar.cfg.ContextFreeGrammar;
import java.awt.Point;
import java.util.ArrayList;

public class UnitProductionRemover {
    public VariableDependencyGraph getVariableDependencyGraph(Grammar grammar) {
        VariableDependencyGraph variableDependencyGraph = new VariableDependencyGraph();
        this.initializeDependencyGraph(variableDependencyGraph, grammar);
        Production[] productionArray = this.getUnitProductions(grammar);
        for (int i = 0; i < productionArray.length; ++i) {
            variableDependencyGraph.addTransition(this.getTransitionForUnitProduction(productionArray[i], variableDependencyGraph));
        }
        return variableDependencyGraph;
    }

    public Production[] getUnitProductions(Grammar grammar) {
        ArrayList<Production> arrayList = new ArrayList<Production>();
        ProductionChecker productionChecker = new ProductionChecker();
        Production[] productionArray = grammar.getProductions();
        for (int i = 0; i < productionArray.length; ++i) {
            if (!ProductionChecker.isUnitProduction(productionArray[i])) continue;
            arrayList.add(productionArray[i]);
        }
        return arrayList.toArray(new Production[0]);
    }

    public Production[] getNonUnitProductions(Grammar grammar) {
        ArrayList<Production> arrayList = new ArrayList<Production>();
        ProductionChecker productionChecker = new ProductionChecker();
        Production[] productionArray = grammar.getProductions();
        for (int i = 0; i < productionArray.length; ++i) {
            if (ProductionChecker.isUnitProduction(productionArray[i])) continue;
            arrayList.add(productionArray[i]);
        }
        return arrayList.toArray(new Production[0]);
    }

    public void initializeDependencyGraph(VariableDependencyGraph variableDependencyGraph, Grammar grammar) {
        String[] stringArray = grammar.getVariables();
        for (int i = 0; i < stringArray.length; ++i) {
            double d = Math.PI * 2 * (double)i / (double)stringArray.length;
            Point point = new Point(200 + (int)(180.0 * Math.cos(d)), 200 + (int)(180.0 * Math.sin(d)));
            State state = variableDependencyGraph.createState(point);
            state.setName(stringArray[i]);
        }
    }

    public State getStateForVariable(String string, VariableDependencyGraph variableDependencyGraph) {
        State[] stateArray = variableDependencyGraph.getStates();
        for (int i = 0; i < stateArray.length; ++i) {
            if (!stateArray[i].getName().equals(string)) continue;
            return stateArray[i];
        }
        return null;
    }

    public Transition getTransitionForUnitProduction(Production production, VariableDependencyGraph variableDependencyGraph) {
        ProductionChecker productionChecker = new ProductionChecker();
        if (!ProductionChecker.isUnitProduction(production)) {
            return null;
        }
        String string = production.getLHS();
        String string2 = production.getRHS();
        State state = this.getStateForVariable(string, variableDependencyGraph);
        State state2 = this.getStateForVariable(string2, variableDependencyGraph);
        return new VDGTransition(state, state2);
    }

    public void addAllNonUnitProductionsToGrammar(Grammar grammar, Grammar grammar2) {
        Production[] productionArray = this.getNonUnitProductions(grammar);
        for (int i = 0; i < productionArray.length; ++i) {
            grammar2.addProduction(productionArray[i]);
        }
    }

    public boolean isDependentOn(String string, String string2, VariableDependencyGraph variableDependencyGraph) {
        State state = this.getStateForVariable(string, variableDependencyGraph);
        State state2 = this.getStateForVariable(string2, variableDependencyGraph);
        variableDependencyGraph.setInitialState(state);
        UnreachableStatesDetector unreachableStatesDetector = new UnreachableStatesDetector(variableDependencyGraph);
        State[] stateArray = unreachableStatesDetector.getUnreachableStates();
        variableDependencyGraph.setInitialState(null);
        for (int i = 0; i < stateArray.length; ++i) {
            if (state2 != stateArray[i]) continue;
            return false;
        }
        return true;
    }

    public String[] getDependencies(String string, Grammar grammar, VariableDependencyGraph variableDependencyGraph) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = grammar.getVariables();
        for (int i = 0; i < stringArray.length; ++i) {
            if (string.equals(stringArray[i]) || !this.isDependentOn(string, stringArray[i], variableDependencyGraph)) continue;
            arrayList.add(stringArray[i]);
        }
        return arrayList.toArray(new String[0]);
    }

    public Production[] getNewProductions(String string, Production[] productionArray) {
        ArrayList<Production> arrayList = new ArrayList<Production>();
        for (int i = 0; i < productionArray.length; ++i) {
            arrayList.add(new Production(string, productionArray[i].getRHS()));
        }
        return arrayList.toArray(new Production[0]);
    }

    public void addAllNewProductionsToGrammar(Grammar grammar, Grammar grammar2, VariableDependencyGraph variableDependencyGraph) {
        GrammarChecker grammarChecker = new GrammarChecker();
        String[] stringArray = grammar.getVariables();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            String[] stringArray2 = this.getDependencies(string, grammar, variableDependencyGraph);
            for (int j = 0; j < stringArray2.length; ++j) {
                Production[] productionArray = GrammarChecker.getNonUnitProductionsOnVariable(stringArray2[j], grammar);
                grammar2.addProductions(this.getNewProductions(string, productionArray));
            }
        }
    }

    public Grammar getUnitProductionlessGrammar(Grammar grammar, VariableDependencyGraph variableDependencyGraph) {
        ContextFreeGrammar contextFreeGrammar = new ContextFreeGrammar();
        this.addAllNonUnitProductionsToGrammar(grammar, contextFreeGrammar);
        this.addAllNewProductionsToGrammar(grammar, contextFreeGrammar, variableDependencyGraph);
        return contextFreeGrammar;
    }
}

