/*
 * Decompiled with CFR 0.152.
 */
package grammar;

import grammar.ProductionChecker;
import gui.environment.Universe;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeSet;

public class Production
implements Serializable {
    protected String myLHS;
    protected String myRHS;

    public Production(String string, String string2) {
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        this.myLHS = string;
        this.myRHS = string2;
    }

    public void setRHS(String string) {
        this.myRHS = string;
    }

    public void setLHS(String string) {
        this.myLHS = string;
    }

    public String getLHS() {
        return this.myLHS;
    }

    public String getRHS() {
        return this.myRHS;
    }

    public String[] getSymbols() {
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.addAll(Arrays.asList(this.getVariables()));
        treeSet.addAll(Arrays.asList(this.getTerminals()));
        return treeSet.toArray(new String[0]);
    }

    public String[] getVariables() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = this.getVariablesOnRHS();
        for (int i = 0; i < stringArray.length; ++i) {
            if (arrayList.contains(stringArray[i])) continue;
            arrayList.add(stringArray[i]);
        }
        String[] stringArray2 = this.getVariablesOnLHS();
        for (int i = 0; i < stringArray2.length; ++i) {
            if (arrayList.contains(stringArray2[i])) continue;
            arrayList.add(stringArray2[i]);
        }
        return arrayList.toArray(new String[0]);
    }

    public String[] getVariablesOnLHS() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.myLHS == null) {
            return new String[0];
        }
        for (int i = 0; i < this.myLHS.length(); ++i) {
            char c = this.myLHS.charAt(i);
            if (!ProductionChecker.isVariable(c)) continue;
            arrayList.add(this.myLHS.substring(i, i + 1));
        }
        return arrayList.toArray(new String[0]);
    }

    public String[] getVariablesOnRHS() {
        ProductionChecker productionChecker = new ProductionChecker();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.myRHS.length(); ++i) {
            char c = this.myRHS.charAt(i);
            if (!ProductionChecker.isVariable(c)) continue;
            arrayList.add(this.myRHS.substring(i, i + 1));
        }
        return arrayList.toArray(new String[0]);
    }

    public String[] getTerminals() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = this.getTerminalsOnRHS();
        for (int i = 0; i < stringArray.length; ++i) {
            if (arrayList.contains(stringArray[i])) continue;
            arrayList.add(stringArray[i]);
        }
        String[] stringArray2 = this.getTerminalsOnLHS();
        for (int i = 0; i < stringArray2.length; ++i) {
            if (arrayList.contains(stringArray2[i])) continue;
            arrayList.add(stringArray2[i]);
        }
        return arrayList.toArray(new String[0]);
    }

    public String[] getTerminalsOnRHS() {
        ProductionChecker productionChecker = new ProductionChecker();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.myRHS.length(); ++i) {
            char c = this.myRHS.charAt(i);
            if (!ProductionChecker.isTerminal(c)) continue;
            arrayList.add(this.myRHS.substring(i, i + 1));
        }
        return arrayList.toArray(new String[0]);
    }

    public boolean equals(Object object) {
        if (object instanceof Production) {
            Production production = (Production)object;
            return this.getRHS().equals(production.getRHS()) && this.getLHS().equals(production.getLHS());
        }
        return false;
    }

    public int hashCode() {
        return this.myRHS.hashCode() ^ this.myLHS.hashCode();
    }

    public String[] getTerminalsOnLHS() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.myLHS.length(); ++i) {
            char c = this.myLHS.charAt(i);
            if (!ProductionChecker.isTerminal(c)) continue;
            arrayList.add(this.myLHS.substring(i, i + 1));
        }
        return arrayList.toArray(new String[0]);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getLHS());
        stringBuffer.append('\u2192');
        String string = this.getRHS();
        stringBuffer.append(string.length() == 0 ? Universe.curProfile.getEmptyString() : string);
        return stringBuffer.toString();
    }

    public String[] getSymbolsOnRHS() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.myRHS.length(); ++i) {
            char c = this.myRHS.charAt(i);
            arrayList.add(this.myRHS.substring(i, i + 1));
        }
        return arrayList.toArray(new String[0]);
    }
}

