/*
 * Decompiled with CFR 0.152.
 */
package grammar;

import grammar.GrammarChecker;
import grammar.Production;
import gui.environment.EnvironmentFrame;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class Grammar
implements Serializable,
Cloneable {
    private EnvironmentFrame myEnvFrame = null;
    private String fileName = "";
    protected Set myVariables;
    protected Set myTerminals;
    protected String myStartVariable = null;
    protected List myProductions = new ArrayList();

    public Grammar() {
        this.myVariables = new HashSet();
        this.myTerminals = new HashSet();
    }

    public abstract boolean isConverted();

    public Object clone() {
        Grammar grammar;
        try {
            grammar = (Grammar)this.getClass().newInstance();
        }
        catch (Throwable throwable) {
            System.err.println("Warning: clone of grammar failed!");
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String[] stringArray = this.getVariables();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            String string2 = new String(stringArray[i]);
            hashMap.put(string, string2);
            grammar.addVariable(string2);
        }
        grammar.setStartVariable((String)hashMap.get(this.getStartVariable()));
        String[] stringArray2 = this.getTerminals();
        for (int i = 0; i < stringArray2.length; ++i) {
            grammar.addTerminal(new String(stringArray2[i]));
        }
        Production[] productionArray = this.getProductions();
        for (int i = 0; i < productionArray.length; ++i) {
            String string = productionArray[i].getRHS();
            String string3 = productionArray[i].getLHS();
            grammar.addProduction(new Production(string, string3));
        }
        return grammar;
    }

    public void setStartVariable(String string) {
        this.myStartVariable = string;
    }

    public String getStartVariable() {
        return this.myStartVariable;
    }

    public boolean isValidProduction(Production production) {
        try {
            this.checkProduction(production);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public abstract void checkProduction(Production var1);

    public void addProduction(Production production) {
        this.checkProduction(production);
        GrammarChecker grammarChecker = new GrammarChecker();
        if (GrammarChecker.isProductionInGrammar(production, this)) {
            return;
        }
        this.myProductions.add(production);
        String[] stringArray = production.getVariables();
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.myVariables.contains(stringArray[i])) continue;
            this.addVariable(stringArray[i]);
        }
        String[] stringArray2 = production.getTerminals();
        for (int i = 0; i < stringArray2.length; ++i) {
            if (this.myTerminals.contains(stringArray2[i])) continue;
            this.addTerminal(stringArray2[i]);
        }
    }

    public void addProductions(Production[] productionArray) {
        for (int i = 0; i < productionArray.length; ++i) {
            this.addProduction(productionArray[i]);
        }
    }

    public void removeProduction(Production production) {
        this.myProductions.remove(production);
        GrammarChecker grammarChecker = new GrammarChecker();
        String[] stringArray = production.getVariables();
        for (int i = 0; i < stringArray.length; ++i) {
            if (GrammarChecker.isVariableInProductions(this, stringArray[i])) continue;
            this.removeVariable(stringArray[i]);
        }
        String[] stringArray2 = production.getTerminals();
        for (int i = 0; i < stringArray2.length; ++i) {
            if (GrammarChecker.isTerminalInProductions(this, stringArray2[i])) continue;
            this.removeTerminal(stringArray2[i]);
        }
    }

    public Production[] getProductions() {
        return this.myProductions.toArray(new Production[0]);
    }

    private void addTerminal(String string) {
        this.myTerminals.add(string);
    }

    private void removeTerminal(String string) {
        this.myTerminals.remove(string);
    }

    public String[] getTerminals() {
        return this.myTerminals.toArray(new String[0]);
    }

    private void addVariable(String string) {
        this.myVariables.add(string);
    }

    private void removeVariable(String string) {
        this.myVariables.remove(string);
    }

    public String[] getVariables() {
        return this.myVariables.toArray(new String[0]);
    }

    public boolean isProduction(Production production) {
        return this.myProductions.contains(production);
    }

    public boolean isTerminal(String string) {
        return this.myTerminals.contains(string);
    }

    public boolean isVariable(String string) {
        return this.myVariables.contains(string);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append('\n');
        stringBuffer.append("V: ");
        String[] stringArray = this.getVariables();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            stringBuffer.append(" ");
        }
        stringBuffer.append('\n');
        stringBuffer.append("T: ");
        String[] stringArray2 = this.getTerminals();
        for (int i = 0; i < stringArray2.length; ++i) {
            stringBuffer.append(stringArray2[i]);
            stringBuffer.append(" ");
        }
        stringBuffer.append('\n');
        stringBuffer.append("S: ");
        stringBuffer.append(this.getStartVariable());
        stringBuffer.append('\n');
        stringBuffer.append("P: ");
        stringBuffer.append('\n');
        Production[] productionArray = this.getProductions();
        for (int i = 0; i < productionArray.length; ++i) {
            stringBuffer.append(productionArray[i].toString());
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public void setEnvironmentFrame(EnvironmentFrame environmentFrame) {
        this.myEnvFrame = environmentFrame;
    }

    public EnvironmentFrame getEnvironmentFrame() {
        return this.myEnvFrame;
    }

    public void setFilePath(String string) {
        this.fileName = string;
    }

    public String getFileName() {
        int n = this.fileName.lastIndexOf("\\");
        if (n == -1) {
            n = this.fileName.lastIndexOf("/");
        }
        return this.fileName.substring(n + 1);
    }

    public String getFilePath() {
        int n = this.fileName.lastIndexOf("\\");
        if (n == -1) {
            n = this.fileName.lastIndexOf("/");
        }
        return this.fileName.substring(0, n + 1);
    }
}

