/*
 * Decompiled with CFR 0.152.
 */
package grammar;

import grammar.Grammar;
import grammar.Production;
import grammar.ProductionComparator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class CNFConverter {
    private boolean leftAdded;
    private int numVariables = 0;
    private ProductionComparator productionComparator;
    private ProductionDirectory productionDirectory;
    private Grammar grammar;

    public CNFConverter(Grammar grammar) {
        this.grammar = grammar;
        this.productionComparator = new ProductionComparator(grammar);
        this.productionDirectory = new ProductionDirectory(grammar);
    }

    public static String[] separateString(String string) {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (int i = string.length() - 1; i >= 0; --i) {
            int n = i;
            if (string.charAt(i) != ')') {
                linkedList.addFirst(string.substring(i, i + 1));
                continue;
            }
            while (i > 0 && string.charAt(i) != '(') {
                --i;
            }
            if (i > 0) {
                --i;
            }
            linkedList.addFirst(string.substring(i, n + 1));
        }
        return linkedList.toArray(new String[0]);
    }

    private String getLeft(String string) {
        String string2 = this.productionDirectory.getLeft(string);
        this.leftAdded = false;
        if (string2 != null) {
            return string2;
        }
        this.leftAdded = true;
        string2 = this.grammar.isTerminal(string) ? "B(" + string + ")" : "D(" + ++this.numVariables + ")";
        Production production = new Production(string2, string);
        this.productionDirectory.add(production);
        return string2;
    }

    public static Production[] convert(Production[] productionArray) {
        Object object;
        int n;
        TreeSet<String> treeSet = new TreeSet<String>();
        for (char c = 'A'; c <= 'Z'; c = (char)(c + '\u0001')) {
            treeSet.add("" + c);
        }
        TreeSet<String> treeSet2 = new TreeSet<String>();
        for (n = 0; n < productionArray.length; ++n) {
            object = CNFConverter.separateString(productionArray[n].getRHS());
            for (int i = 0; i < ((String[])object).length; ++i) {
                if (object[i].length() == 1) {
                    treeSet.remove(object[i]);
                    continue;
                }
                treeSet2.add(object[i]);
            }
            treeSet.remove(productionArray[n].getLHS());
        }
        n = treeSet2.size() + 26 - treeSet.size();
        if (treeSet2.size() > treeSet.size()) {
            throw new UnsupportedOperationException("26 variables available, but " + n + " needed!");
        }
        object = new HashMap();
        Iterator iterator = treeSet2.iterator();
        Iterator iterator2 = treeSet.iterator();
        while (iterator.hasNext()) {
            ((HashMap)object).put(iterator.next(), iterator2.next());
        }
        Production[] productionArray2 = new Production[productionArray.length];
        for (int i = 0; i < productionArray.length; ++i) {
            String[] stringArray = CNFConverter.separateString(productionArray[i].getRHS());
            String string = "";
            for (int j = 0; j < stringArray.length; ++j) {
                string = stringArray[j].length() == 1 ? string + stringArray[j] : string + ((HashMap)object).get(stringArray[j]);
            }
            String string2 = productionArray[i].getLHS();
            if (string2.length() != 1) {
                string2 = (String)((HashMap)object).get(string2);
            }
            productionArray2[i] = new Production(string2, string);
        }
        return productionArray2;
    }

    public Production[] replacements(Production production) {
        String string = production.getRHS();
        String string2 = production.getLHS();
        if (string.length() == 1) {
            throw new IllegalArgumentException(production + " is a terminal production!");
        }
        String[] stringArray = CNFConverter.separateString(string);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.grammar.isTerminal(stringArray[i])) continue;
            return this.determinalize(production);
        }
        if (stringArray.length <= 2) {
            if (stringArray.length == 2) {
                throw new IllegalArgumentException(production + " has two variables already!");
            }
            throw new IllegalArgumentException(production + " is in bad form!");
        }
        String string3 = string.substring(stringArray[0].length());
        String string4 = this.getLeft(string3);
        if (this.leftAdded) {
            return new Production[]{new Production(string2, stringArray[0] + string4), new Production(string4, string3)};
        }
        return new Production[]{new Production(string2, stringArray[0] + string4)};
    }

    public boolean isChomsky(Production production) {
        String[] stringArray = CNFConverter.separateString(production.getRHS());
        switch (stringArray.length) {
            case 1: {
                return this.grammar.isTerminal(stringArray[0]);
            }
            case 2: {
                return !this.grammar.isTerminal(stringArray[0]) && !this.grammar.isTerminal(stringArray[1]);
            }
        }
        return false;
    }

    public Production[] determinalize(Production production) {
        String[] stringArray = CNFConverter.separateString(production.getRHS());
        ArrayList<Production> arrayList = new ArrayList<Production>();
        String string = "";
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.grammar.isTerminal(stringArray[i])) {
                String string2 = this.getLeft(stringArray[i]);
                if (this.leftAdded) {
                    arrayList.add(new Production(string2, stringArray[i]));
                }
                string = string + string2;
                continue;
            }
            string = string + stringArray[i];
        }
        arrayList.add(0, new Production(production.getLHS(), string));
        return arrayList.toArray(new Production[0]);
    }

    private class ProductionDirectory {
        private List productions = new ArrayList();
        private Map lhsToRhs = new TreeMap();
        private Map rhsToLhs = new HashMap();

        public ProductionDirectory(Grammar grammar) {
            HashSet<Object> hashSet;
            Object object;
            Production[] productionArray = grammar.getProductions();
            for (int i = 0; i < productionArray.length; ++i) {
                String object2 = productionArray[i].getLHS();
                object = productionArray[i].getRHS();
                if (((String)object).indexOf(40) != -1) {
                    throw new IllegalArgumentException("Grammar has the ( character, which is reserved.");
                }
                if (((String)object).indexOf(41) != -1) {
                    throw new IllegalArgumentException("Grammar has the ) character, which is reserved.");
                }
                this.productions.add(productionArray[i]);
                hashSet = (Set)this.lhsToRhs.get(object2);
                if (hashSet == null) {
                    hashSet = new HashSet<Object>();
                    this.lhsToRhs.put(object2, hashSet);
                }
                hashSet.add(object);
            }
            for (Map.Entry entry : this.lhsToRhs.entrySet()) {
                object = (Set)entry.getValue();
                hashSet = object.iterator();
                String string = (String)hashSet.next();
                if (hashSet.hasNext()) continue;
                this.rhsToLhs.put(string, entry.getKey());
            }
        }

        public void add(Production production) {
            String string = production.getLHS();
            String string2 = production.getRHS();
            if (this.rhsToLhs.containsKey(string2)) {
                throw new IllegalArgumentException(string2 + " already represented by " + this.rhsToLhs.get(string2));
            }
            HashSet<String> hashSet = (HashSet<String>)this.lhsToRhs.get(string);
            if (hashSet == null) {
                hashSet = new HashSet<String>();
                this.lhsToRhs.put(string, hashSet);
            }
            hashSet.add(string2);
            this.rhsToLhs.put(string2, string);
        }

        public String[] getRight(String string) {
            Set set = (Set)this.lhsToRhs.get(string);
            return set.toArray(new String[0]);
        }

        public String getLeft(String string) {
            return (String)this.rhsToLhs.get(string);
        }
    }
}

