/*
 * Decompiled with CFR 0.152.
 */
package file.xml;

import file.ParseException;
import file.xml.AbstractTransducer;
import java.io.Serializable;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import regular.RegularExpression;

public class RETransducer
extends AbstractTransducer {
    public static final String EXPRESSION_NAME = "expression";
    private static final String COMMENT_EXPRESSION = "The regular expression.";

    @Override
    public String getType() {
        return "re";
    }

    @Override
    public Serializable fromDOM(Document document) {
        Map map = RETransducer.elementsToText(document.getDocumentElement());
        String string = (String)map.get(EXPRESSION_NAME);
        if (string == null) {
            if (map.containsKey(EXPRESSION_NAME)) {
                throw new ParseException("Regular expression structure has no expression tag!");
            }
            string = "";
        }
        return new RegularExpression(string);
    }

    @Override
    public Document toDOM(Serializable serializable) {
        RegularExpression regularExpression = (RegularExpression)serializable;
        Document document = this.newEmptyDocument();
        Element element = document.getDocumentElement();
        element.appendChild(RETransducer.createComment(document, COMMENT_EXPRESSION));
        element.appendChild(RETransducer.createElement(document, EXPRESSION_NAME, null, regularExpression.asString()));
        return document;
    }
}

