/*
 * Decompiled with CFR 0.152.
 */
package file.xml;

import file.ParseException;
import file.xml.AbstractTransducer;
import grammar.Grammar;
import grammar.Production;
import grammar.UnboundGrammar;
import grammar.lsystem.LSystem;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LSystemTransducer
extends AbstractTransducer {
    public static final String AXIOM_NAME = "axiom";
    public static final String RULE_NAME = "production";
    public static final String RULE_LEFT_NAME = "left";
    public static final String RULE_RIGHT_NAME = "right";
    public static final String PARAMETER_NAME = "parameter";
    public static final String PARAMETER_NAME_NAME = "name";
    public static final String PARAMETER_VALUE_NAME = "value";
    private static final String COMMENT_AXIOM = "The L-system axiom.";
    private static final String COMMENT_RULE = "The rewriting rules.";
    private static final String COMMENT_PARAMETER = "The drawing parameters.";

    @Override
    public String getType() {
        return "lsystem";
    }

    private static String listAsString(List list) {
        Iterator iterator = list.iterator();
        if (!iterator.hasNext()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(iterator.next());
        while (iterator.hasNext()) {
            stringBuffer.append(' ');
            stringBuffer.append(iterator.next());
        }
        return stringBuffer.toString();
    }

    private static Production[] createRules(Node node) {
        Map map = LSystemTransducer.elementsToText(node);
        String string = (String)map.get(RULE_LEFT_NAME);
        if (string == null) {
            string = "";
        }
        NodeList nodeList = ((Element)node).getElementsByTagName(RULE_RIGHT_NAME);
        Production[] productionArray = new Production[nodeList.getLength()];
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string2 = LSystemTransducer.containedText(nodeList.item(i));
            productionArray[i] = new Production(string, string2 == null ? "" : string2);
        }
        return productionArray;
    }

    public static Element createRuleElement(Document document, LSystem lSystem, String string) {
        Element element = LSystemTransducer.createElement(document, RULE_NAME, null, null);
        element.appendChild(LSystemTransducer.createElement(document, RULE_LEFT_NAME, null, string));
        List[] listArray = lSystem.getReplacements(string);
        for (int i = 0; i < listArray.length; ++i) {
            element.appendChild(LSystemTransducer.createElement(document, RULE_RIGHT_NAME, null, LSystemTransducer.listAsString(listArray[i])));
        }
        return element;
    }

    private String readAxiom(Document document) {
        NodeList nodeList = document.getDocumentElement().getElementsByTagName(AXIOM_NAME);
        if (nodeList.getLength() < 1) {
            throw new ParseException("No axiom specified in the document!");
        }
        String string = LSystemTransducer.containedText(nodeList.item(nodeList.getLength() - 1));
        if (string == null) {
            string = "";
        }
        return string;
    }

    private Grammar readGrammar(Document document) {
        UnboundGrammar unboundGrammar = new UnboundGrammar();
        NodeList nodeList = document.getDocumentElement().getElementsByTagName(RULE_NAME);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Production[] productionArray = LSystemTransducer.createRules(nodeList.item(i));
            for (int j = 0; j < productionArray.length; ++j) {
                unboundGrammar.addProduction(productionArray[j]);
            }
        }
        return unboundGrammar;
    }

    private Map readParameters(Document document) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        NodeList nodeList = document.getDocumentElement().getElementsByTagName(PARAMETER_NAME);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Map map = LSystemTransducer.elementsToText(nodeList.item(i));
            String string = (String)map.get(PARAMETER_NAME_NAME);
            String string2 = (String)map.get(PARAMETER_VALUE_NAME);
            if (string == null) continue;
            if (string2 == null) {
                string2 = "";
            }
            hashMap.put(string, string2);
        }
        return hashMap;
    }

    @Override
    public Serializable fromDOM(Document document) {
        String string = this.readAxiom(document);
        Grammar grammar = this.readGrammar(document);
        Map map = this.readParameters(document);
        return new LSystem(string, grammar, map);
    }

    @Override
    public Document toDOM(Serializable serializable) {
        LSystem lSystem = (LSystem)serializable;
        Document document = this.newEmptyDocument();
        Element element = document.getDocumentElement();
        element.appendChild(LSystemTransducer.createComment(document, COMMENT_AXIOM));
        element.appendChild(LSystemTransducer.createElement(document, AXIOM_NAME, null, LSystemTransducer.listAsString(lSystem.getAxiom())));
        Set set = lSystem.getSymbolsWithReplacements();
        Iterator<Object> iterator = set.iterator();
        if (iterator.hasNext()) {
            element.appendChild(LSystemTransducer.createComment(document, COMMENT_RULE));
        }
        while (iterator.hasNext()) {
            element.appendChild(LSystemTransducer.createRuleElement(document, lSystem, (String)iterator.next()));
        }
        Map map = lSystem.getValues();
        iterator = map.keySet().iterator();
        if (iterator.hasNext()) {
            element.appendChild(LSystemTransducer.createComment(document, COMMENT_PARAMETER));
        }
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)map.get(string);
            Element element2 = LSystemTransducer.createElement(document, PARAMETER_NAME, null, null);
            element2.appendChild(LSystemTransducer.createElement(document, PARAMETER_NAME_NAME, null, string));
            element2.appendChild(LSystemTransducer.createElement(document, PARAMETER_VALUE_NAME, null, string2));
            element.appendChild(element2);
        }
        return document;
    }
}

