/*
 * Decompiled with CFR 0.152.
 */
package automata.turing;

import automata.Automaton;
import automata.Note;
import automata.State;
import automata.Transition;
import automata.turing.TMState;
import automata.turing.TMTransition;
import gui.action.OpenAction;
import java.awt.Point;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.text.JTextComponent;

public class TuringMachine
extends Automaton {
    public int tapes;
    public boolean isOuterMost;
    private TMState parent = null;

    public TuringMachine() {
        this(1);
    }

    public TuringMachine(int n) {
        this.tapes = n;
    }

    @Override
    protected Class getTransitionClass() {
        return TMTransition.class;
    }

    @Override
    public void addTransition(Transition transition) {
        try {
            int n = ((TMTransition)transition).tapes();
            if (this.tapes == 0) {
                this.tapes = n;
            }
            if (n != this.tapes) {
                throw new IllegalArgumentException("Transition has " + n + " tapes while TM has " + this.tapes);
            }
            super.addTransition(transition);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public int tapes() {
        return this.tapes;
    }

    @Override
    public State createState(Point point) {
        return this.createTMState(point);
    }

    @Override
    public Object clone() {
        Transition[] transitionArray;
        TMState tMState;
        TuringMachine turingMachine = new TuringMachine(this.tapes());
        turingMachine.setEnvironmentFrame(this.getEnvironmentFrame());
        HashMap<TMState, Transition[]> hashMap = new HashMap<TMState, Transition[]>();
        for (Object e : this.states) {
            tMState = (TMState)e;
            transitionArray = new TMState(tMState);
            transitionArray.setAutomaton(turingMachine);
            transitionArray.setLabel(tMState.getLabel());
            transitionArray.setName(tMState.getName());
            hashMap.put(tMState, transitionArray);
            turingMachine.addState((State)transitionArray);
        }
        for (Object e : this.finalStates) {
            tMState = (TMState)e;
            turingMachine.addFinalState((State)hashMap.get(tMState));
        }
        turingMachine.setInitialState((TMState)hashMap.get((TMState)this.getInitialState()));
        for (Object e : this.states) {
            tMState = (TMState)e;
            transitionArray = this.getTransitionsFromState(tMState);
            TMState tMState2 = (TMState)hashMap.get(tMState);
            for (int i = 0; i < transitionArray.length; ++i) {
                TMState tMState3 = (TMState)hashMap.get(transitionArray[i].getToState());
                Transition transition = (Transition)transitionArray[i].clone();
                transition.setFromState(tMState2);
                transition.setToState(tMState3);
                turingMachine.addTransition(transition);
            }
        }
        return turingMachine;
    }

    public final TMState createBlock(Point point) {
        int n = 0;
        while (this.getStateWithID(n) != null) {
            ++n;
        }
        OpenAction openAction = new OpenAction();
        OpenAction.setOpenOrRead(true);
        JButton jButton = new JButton(openAction);
        jButton.doClick();
        OpenAction.setOpenOrRead(false);
        return this.getAutomatonFromFile(n, point);
    }

    private TMState getAutomatonFromFile(int n, Point point) {
        TMState tMState = new TMState(n, point, this);
        Serializable serializable = OpenAction.getLastObjectOpened();
        File file = OpenAction.getLastFileOpened();
        if (file == null || !OpenAction.isOpened()) {
            return null;
        }
        assert (serializable instanceof TuringMachine);
        TuringMachine turingMachine = (TuringMachine)serializable;
        turingMachine.setEnvironmentFrame(this.getEnvironmentFrame());
        tMState.setInternalName(file.getName());
        tMState.setInnerTM(turingMachine);
        tMState.setName(file.getName().substring(0, file.getName().length() - 4));
        this.addState(tMState);
        return tMState;
    }

    public final TMState createTMStateWithID(Point point, int n) {
        TMState tMState = new TMState(n, point, this);
        this.addState(tMState);
        return tMState;
    }

    public final TMState createTMState(Point point) {
        int n = 0;
        while (this.getStateWithID(n) != null) {
            ++n;
        }
        TMState tMState = new TMState(n, point, this);
        this.addState(tMState);
        return tMState;
    }

    public TMState createInnerTM(Point point, Serializable serializable, String string, int n) {
        TMState tMState = new TMState(n, point, this);
        TuringMachine turingMachine = (TuringMachine)serializable;
        this.addState(tMState);
        tMState.setInnerTM(turingMachine);
        tMState.setInternalName(string);
        return tMState;
    }

    public static void become(TuringMachine turingMachine, TuringMachine turingMachine2) {
        Transition[] transitionArray;
        TMState tMState;
        System.out.println("Calling the real become");
        turingMachine.clear();
        HashMap<TMState, Transition[]> hashMap = new HashMap<TMState, Transition[]>();
        for (Object object : turingMachine2.states) {
            System.out.println(object.getClass().getName());
            tMState = (TMState)object;
            transitionArray = new TMState(tMState.getID(), new Point(tMState.getPoint()), turingMachine);
            transitionArray.setLabel(tMState.getLabel());
            transitionArray.setName(tMState.getName());
            hashMap.put(tMState, transitionArray);
            turingMachine.addState((State)transitionArray);
        }
        for (Object object : turingMachine2.finalStates) {
            tMState = (TMState)object;
            turingMachine.addFinalState((State)hashMap.get(tMState));
        }
        turingMachine.setInitialState((TMState)hashMap.get((TMState)turingMachine2.getInitialState()));
        for (Object object : turingMachine2.states) {
            tMState = (TMState)object;
            transitionArray = turingMachine2.getTransitionsFromState(tMState);
            TMState tMState2 = (TMState)hashMap.get(tMState);
            for (int i = 0; i < transitionArray.length; ++i) {
                TMState tMState3 = (TMState)hashMap.get(transitionArray[i].getToState());
                Transition transition = (Transition)transitionArray[i].clone();
                transition.setFromState(tMState2);
                transition.setToState(tMState3);
                turingMachine.addTransition(transition);
            }
        }
        for (int i = 0; i < turingMachine2.getNotes().size(); ++i) {
            Object object;
            object = (Note)turingMachine2.getNotes().get(i);
            turingMachine.addNote(new Note(((Note)object).getAutoPoint(), ((JTextComponent)object).getText()));
            ((Note)turingMachine.getNotes().get(i)).initializeForView(((Note)object).getView());
        }
        turingMachine.setEnvironmentFrame(turingMachine2.getEnvironmentFrame());
    }

    public Map<String, TuringMachine> getBlockMap() {
        HashMap<String, TuringMachine> hashMap = new HashMap<String, TuringMachine>();
        for (TMState tMState : this.states) {
            hashMap.put(tMState.getInternalName(), tMState.getInnerTM());
        }
        return hashMap;
    }

    public void setParent(TMState tMState) {
        this.parent = tMState;
    }

    public TMState getParent() {
        return this.parent;
    }
}

