/*
 * Decompiled with CFR 0.152.
 */
package automata.turing;

import automata.Configuration;
import automata.State;
import automata.turing.AcceptanceFilter;
import automata.turing.Tape;

public class TMConfiguration
extends Configuration
implements Cloneable {
    protected Tape[] myTapes;
    private AcceptanceFilter[] myFilters;
    private boolean isHalted = false;

    public TMConfiguration(State state, TMConfiguration tMConfiguration, Tape[] tapeArray, AcceptanceFilter[] acceptanceFilterArray) {
        super(state, tMConfiguration);
        this.myTapes = tapeArray;
        this.myFilters = acceptanceFilterArray;
    }

    public Tape[] getTapes() {
        return this.myTapes;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        for (int i = 0; i < this.myTapes.length; ++i) {
            stringBuffer.append(" TAPE ");
            stringBuffer.append(i);
            stringBuffer.append(": ");
            stringBuffer.append(this.myTapes[i].toString());
        }
        return stringBuffer.toString();
    }

    @Override
    public boolean isAccept() {
        for (int i = 0; i < this.myFilters.length; ++i) {
            if (!this.myFilters[i].accept(this)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        try {
            if (!super.equals(object)) {
                return false;
            }
            Tape[] tapeArray = ((TMConfiguration)object).myTapes;
            if (tapeArray.length != this.myTapes.length) {
                return false;
            }
            for (int i = 0; i < tapeArray.length; ++i) {
                if (tapeArray[i].equals(this.myTapes[i])) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        for (int i = 0; i < this.myTapes.length; ++i) {
            n ^= this.myTapes[i].hashCode();
        }
        return n;
    }

    public boolean isHalted() {
        return this.isHalted;
    }

    public void setHalted(boolean bl) {
        this.isHalted = bl;
    }

    public Object clone() {
        TMConfiguration tMConfiguration = new TMConfiguration(this.getCurrentState(), (TMConfiguration)this.getParent(), this.myTapes, this.myFilters);
        tMConfiguration.setFocused(this.getFocused());
        tMConfiguration.setHalted(this.isHalted());
        return tMConfiguration;
    }
}

