/*
 * Decompiled with CFR 0.152.
 */
package automata.pda;

import automata.Automaton;
import automata.Configuration;
import automata.State;
import automata.pda.CharacterStack;

public class PDAConfiguration
extends Configuration {
    protected int myAcceptance;
    protected static final int EMPTY_STACK = 0;
    protected static final int FINAL_STATE = 1;
    protected String myInput;
    protected String myUnprocessedInput;
    protected CharacterStack myStack;

    public PDAConfiguration(State state, PDAConfiguration pDAConfiguration, String string, String string2, CharacterStack characterStack, int n) {
        super(state, pDAConfiguration);
        this.myInput = string;
        this.myUnprocessedInput = string2;
        this.myStack = characterStack;
        this.myAcceptance = n;
    }

    public String getInput() {
        return this.myInput;
    }

    public String getUnprocessedInput() {
        return this.myUnprocessedInput;
    }

    public void setUnprocessedInput(String string) {
        this.myUnprocessedInput = string;
    }

    public CharacterStack getStack() {
        return this.myStack;
    }

    @Override
    public String toString() {
        return super.toString() + " INPUT: " + this.getUnprocessedInput() + " STACK: " + this.myStack.toString();
    }

    @Override
    public boolean isAccept() {
        if (this.myAcceptance == 1) {
            if (this.getUnprocessedInput().length() != 0) {
                return false;
            }
            State state = this.getCurrentState();
            Automaton automaton = state.getAutomaton();
            return automaton.isFinalState(state);
        }
        if (this.myAcceptance == 0) {
            CharacterStack characterStack = this.getStack();
            if (this.getUnprocessedInput() == "" && characterStack.height() == 0) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        try {
            return super.equals(object) && this.myUnprocessedInput.equals(((PDAConfiguration)object).myUnprocessedInput) && this.myStack.equals(((PDAConfiguration)object).myStack);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.myStack.hashCode() ^ this.myUnprocessedInput.hashCode();
    }
}

