/*
 * Decompiled with CFR 0.152.
 */
package automata.graph.layout;

import automata.graph.AutomatonDirectedGraph;
import automata.graph.Graph;
import automata.graph.LayoutAlgorithm;
import automata.graph.layout.VertexChain;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;

public class TreeLayoutAlgorithm
extends LayoutAlgorithm {
    protected Graph graph;
    protected boolean hierarchical;

    public TreeLayoutAlgorithm(boolean bl) {
        this.hierarchical = bl;
    }

    public TreeLayoutAlgorithm(Dimension dimension, Dimension dimension2, double d, boolean bl) {
        super(dimension, dimension2, d);
        this.hierarchical = bl;
    }

    @Override
    public void layout(Graph graph, Set set) {
        Object object;
        this.graph = graph;
        ArrayList arrayList = TreeLayoutAlgorithm.getMovableVertices(this.graph, set);
        if (this.graph == null || arrayList.size() == 0) {
            return;
        }
        if (this.hierarchical) {
            if (!(this.graph instanceof AutomatonDirectedGraph)) {
                return;
            }
            object = (AutomatonDirectedGraph)this.graph;
            Collections.sort(arrayList, new Comparator((AutomatonDirectedGraph)object){
                final /* synthetic */ AutomatonDirectedGraph val$adg;
                {
                    this.val$adg = automatonDirectedGraph;
                }

                public int compare(Object object, Object object2) {
                    if (this.val$adg.toDegree(object, true) == this.val$adg.toDegree(object2, true)) {
                        return 0;
                    }
                    if (this.val$adg.toDegree(object, true) > this.val$adg.toDegree(object2, true)) {
                        return 1;
                    }
                    return -1;
                }
            });
        } else {
            Collections.sort(arrayList, new Comparator(){

                public int compare(Object object, Object object2) {
                    if (TreeLayoutAlgorithm.this.graph.degree(object) == TreeLayoutAlgorithm.this.graph.degree(object2)) {
                        return 0;
                    }
                    if (TreeLayoutAlgorithm.this.graph.degree(object) > TreeLayoutAlgorithm.this.graph.degree(object2)) {
                        return -1;
                    }
                    return 1;
                }
            });
        }
        object = new ArrayList();
        ((ArrayList)object).addAll(arrayList);
        Level level = new Level();
        while (((ArrayList)object).size() > 0) {
            level.vertices.add(((ArrayList)object).get(0));
            ((ArrayList)object).remove(((ArrayList)object).get(0));
            Level level2 = level;
            while (level2 != null && ((ArrayList)object).size() > 0) {
                level2.processChildren((ArrayList)object);
                level2 = level2.nextLevel;
            }
        }
        level.layout(0.0);
        TreeLayoutAlgorithm.shiftOntoScreen(this.graph, this.size, this.vertexDim, true);
    }

    private class Level {
        public ArrayList vertices = new ArrayList();
        public Level nextLevel = null;

        public void processChildren(ArrayList arrayList) {
            VertexChain vertexChain = null;
            for (int i = 0; i < this.vertices.size(); ++i) {
                VertexChain vertexChain2 = new VertexChain(TreeLayoutAlgorithm.this.graph);
                for (int j = arrayList.size() - 1; j >= 0; --j) {
                    if (!TreeLayoutAlgorithm.this.graph.hasEdge(this.vertices.get(i), arrayList.get(j)) || this.vertices.get(i).equals(arrayList.get(j))) continue;
                    vertexChain2.addVertex(arrayList.get(j));
                    arrayList.remove(j);
                }
                if (vertexChain != null) {
                    VertexChain.alignTwoChains(vertexChain, vertexChain2, TreeLayoutAlgorithm.this.graph);
                    if (vertexChain.size() > 0) {
                        if (this.nextLevel == null) {
                            this.nextLevel = new Level();
                        }
                        this.nextLevel.vertices.addAll(vertexChain.getVertices());
                    }
                }
                vertexChain = vertexChain2;
            }
            if (vertexChain != null && vertexChain.size() > 0) {
                if (this.nextLevel == null) {
                    this.nextLevel = new Level();
                }
                this.nextLevel.vertices.addAll(vertexChain.getVertices());
            }
        }

        public void layout(double d) {
            double d2 = -1.0 * (double)this.vertices.size() * (TreeLayoutAlgorithm.this.vertexDim.getWidth() + TreeLayoutAlgorithm.this.vertexBuffer) / 2.0;
            for (int i = 0; i < this.vertices.size(); ++i) {
                TreeLayoutAlgorithm.this.graph.moveVertex(this.vertices.get(i), new Point2D.Double(d2, d));
                d2 += TreeLayoutAlgorithm.this.vertexBuffer + TreeLayoutAlgorithm.this.vertexDim.getWidth();
            }
            if (this.nextLevel != null) {
                this.nextLevel.layout(d + TreeLayoutAlgorithm.this.vertexDim.getHeight() + TreeLayoutAlgorithm.this.vertexBuffer);
            }
        }
    }
}

