/*
 * Decompiled with CFR 0.152.
 */
package automata.graph.layout;

import automata.graph.Graph;
import automata.graph.LayoutAlgorithm;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class GEMLayoutAlgorithm
extends LayoutAlgorithm {
    private static final Random RANDOM = new Random();
    private Map records;
    private static final Set EMPTY_SET = new HashSet();
    private static final double Tmax = 256.0;
    private static final double Tmin = 3.0;
    private static final double OPTIMAL_EDGE_LENGTH = 100.0;
    private static final double GRAVITATIONAL_CONSTANT = 0.0625;

    public GEMLayoutAlgorithm() {
    }

    public GEMLayoutAlgorithm(Dimension dimension, Dimension dimension2, double d) {
        super(dimension, dimension2, d);
    }

    @Override
    public void layout(Graph graph, Set set) {
        int n;
        Object[] objectArray;
        if (set == null) {
            set = EMPTY_SET;
        }
        Object[] objectArray2 = graph.vertices();
        int n2 = 120 * (objectArray2.length - set.size());
        double d = 4.0;
        double d2 = 100.0;
        if (set.size() > 0) {
            objectArray = set.toArray();
            n = 0;
            double d3 = 0.0;
            for (int i = 0; i < objectArray.length; ++i) {
                for (int j = i + 1; j < objectArray.length; ++j) {
                    if (!graph.hasEdge(objectArray[i], objectArray[j])) continue;
                    d3 += graph.pointForVertex(objectArray[i]).distance(graph.pointForVertex(objectArray[j]));
                    ++n;
                }
            }
            if (n > 0) {
                d2 = d3 / (double)n;
            }
        }
        objectArray = new double[]{0.0, 0.0};
        this.records = new HashMap();
        for (n = 0; n < objectArray2.length; ++n) {
            Record record = new Record();
            record.point = graph.pointForVertex(objectArray2[n]);
            objectArray[0] = objectArray[0] + record.point.getX();
            objectArray[1] = objectArray[1] + record.point.getY();
            this.records.put(objectArray2[n], record);
        }
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < n2 && d > 3.0; ++i) {
            if (arrayList.isEmpty() && (arrayList = GEMLayoutAlgorithm.getMovableVertices(graph, set)).size() == 0) {
                return;
            }
            int n3 = RANDOM.nextInt(arrayList.size());
            Object e = arrayList.remove(n3);
            Record record = (Record)this.records.get(e);
            Point2D point2D = graph.pointForVertex(e);
            double d4 = graph.degree(e);
            d4 *= 1.0 + d4 / 2.0;
            double[] dArray = new double[]{(double)((objectArray[0] / (double)graph.numberOfVertices() - point2D.getX()) * 0.0625 * d4), (double)((objectArray[1] / (double)graph.numberOfVertices() - point2D.getY()) * 0.0625 * d4)};
            dArray[0] = dArray[0] + (RANDOM.nextDouble() * 10.0 - 5.0);
            dArray[1] = dArray[1] + (RANDOM.nextDouble() * 10.0 - 5.0);
            for (int j = 0; j < objectArray2.length; ++j) {
                int n4;
                if (objectArray2[j] == e) continue;
                Point2D point2D2 = graph.pointForVertex(objectArray2[j]);
                double[] dArray2 = new double[]{point2D.getX() - point2D2.getX(), point2D.getY() - point2D2.getY()};
                double d5 = dArray2[0] * dArray2[0] + dArray2[1] * dArray2[1];
                double d6 = d2 * d2;
                if (dArray2[0] != 0.0 || dArray2[1] != 0.0) {
                    for (n4 = 0; n4 < 2; ++n4) {
                        int n5 = n4;
                        dArray[n5] = dArray[n5] + dArray2[n4] * d6 / d5;
                    }
                }
                if (!graph.hasEdge(e, objectArray2[j])) continue;
                for (n4 = 0; n4 < 2; ++n4) {
                    int n6 = n4;
                    dArray[n6] = dArray[n6] - dArray2[n4] * d5 / (d6 * d4);
                }
            }
            if (dArray[0] == 0.0 && dArray[1] == 0.0) continue;
            double d7 = Math.sqrt(Math.abs(dArray[0] * dArray[0] + dArray[1] * dArray[1]));
            int n7 = 0;
            while (n7 < 2) {
                int n8 = n7++;
                dArray[n8] = dArray[n8] * (record.temperature / d7);
            }
            graph.moveVertex(e, new Point2D.Double(point2D.getX() + dArray[0], point2D.getY() + dArray[1]));
            objectArray[0] = objectArray[0] + dArray[0];
            objectArray[1] = objectArray[1] + dArray[1];
        }
        GEMLayoutAlgorithm.shiftOntoScreen(graph, this.size, this.vertexDim, true);
    }

    private static class Record {
        Point2D point = new Point2D.Double();
        double[] lastImpulse = new double[]{0.0, 0.0};
        double temperature = 3.0;
        double skew = 0.0;

        private Record() {
        }
    }
}

