/*
 * Decompiled with CFR 0.152.
 */
package automata.fsa;

import automata.Automaton;
import automata.State;
import automata.Transition;
import automata.fsa.FSATransition;
import automata.fsa.FiniteStateAutomaton;
import grammar.Production;
import grammar.reg.RegularGrammar;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;

public class FSAToRegularGrammarConverter {
    protected HashMap MAP;
    protected static final String START_VARIABLE = "S";
    protected static final String LAMBDA = "";
    protected LinkedList VARIABLE;

    public void initializeConverter(Automaton automaton) {
        this.MAP = new HashMap();
        State[] stateArray = automaton.getStates();
        State state = automaton.getInitialState();
        this.VARIABLE = new LinkedList();
        for (char c = 'A'; c <= 'Z'; c = (char)(c + '\u0001')) {
            this.VARIABLE.add(LAMBDA + c);
        }
        if (state != null) {
            this.VARIABLE.remove(START_VARIABLE);
            this.MAP.put(state, START_VARIABLE);
        }
        ArrayList<State> arrayList = new ArrayList<State>(Arrays.asList(stateArray));
        arrayList.remove(state);
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                return ((State)object).getID() - ((State)object2).getID();
            }

            @Override
            public boolean equals(Object object) {
                return false;
            }
        });
        for (State state2 : arrayList) {
            this.MAP.put(state2, this.VARIABLE.removeFirst());
        }
    }

    public Production getProductionForTransition(Transition transition) {
        FSATransition fSATransition = (FSATransition)transition;
        State state = fSATransition.getToState();
        State state2 = fSATransition.getFromState();
        String string = fSATransition.getLabel();
        String string2 = (String)this.MAP.get(state2);
        String string3 = string.concat((String)this.MAP.get(state));
        Production production = new Production(string2, string3);
        return production;
    }

    public Production getLambdaProductionForFinalState(Automaton automaton, State state) {
        if (!automaton.isFinalState(state)) {
            System.err.println(state + " IS NOT A FINAL STATE");
            return null;
        }
        String string = (String)this.MAP.get(state);
        String string2 = LAMBDA;
        Production production = new Production(string, string2);
        return production;
    }

    public RegularGrammar convertToRegularGrammar(Automaton automaton) {
        if (!(automaton instanceof FiniteStateAutomaton)) {
            System.err.println("ATTEMPTING TO CONVERT NON FSA TO REGULAR GRAMMAR");
            return null;
        }
        RegularGrammar regularGrammar = new RegularGrammar();
        this.initializeConverter(automaton);
        Transition[] transitionArray = automaton.getTransitions();
        for (int i = 0; i < transitionArray.length; ++i) {
            Production production = this.getProductionForTransition(transitionArray[i]);
            regularGrammar.addProduction(production);
        }
        State[] stateArray = automaton.getFinalStates();
        for (int i = 0; i < stateArray.length; ++i) {
            Production production = this.getLambdaProductionForFinalState(automaton, stateArray[i]);
            regularGrammar.addProduction(production);
        }
        return regularGrammar;
    }

    public String variableForState(State state) {
        return (String)this.MAP.get(state);
    }
}

