/*
 * Decompiled with CFR 0.152.
 */
package automata.fsa;

import automata.Automaton;
import automata.State;
import automata.StatePlacer;
import automata.Transition;
import automata.fsa.FSATransition;
import automata.fsa.FiniteStateAutomaton;
import gui.environment.Universe;
import java.util.ArrayList;
import regular.Discretizer;

public class FSAToRegularExpressionConverter {
    public static final String EMPTY = "\u00f8";
    public static final String LAMBDA_DISPLAY = Universe.curProfile.getEmptyString();
    public static final String LAMBDA = "";
    public static final String KLEENE_STAR = "*";
    public static final String OR = "+";
    public static final String RIGHT_PAREN = ")";
    public static final String LEFT_PAREN = "(";

    private FSAToRegularExpressionConverter() {
    }

    public static boolean isConvertable(Automaton automaton) {
        if (!(automaton instanceof FiniteStateAutomaton)) {
            return false;
        }
        State[] stateArray = automaton.getFinalStates();
        if (stateArray.length != 1) {
            return false;
        }
        State state = automaton.getInitialState();
        return stateArray[0] != state;
    }

    public static boolean areRemovableStates(Automaton automaton) {
        State[] stateArray = automaton.getStates();
        for (int i = 0; i < stateArray.length; ++i) {
            if (!FSAToRegularExpressionConverter.isRemovable(stateArray[i], automaton)) continue;
            return true;
        }
        return false;
    }

    public static boolean isRemovable(State state, Automaton automaton) {
        State[] stateArray = automaton.getFinalStates();
        State state2 = stateArray[0];
        State state3 = automaton.getInitialState();
        return state != state2 && state != state3;
    }

    public static Transition getTransitionForExpression(int n, int n2, String string, Automaton automaton) {
        State state = automaton.getStateWithID(n);
        State state2 = automaton.getStateWithID(n2);
        FSATransition fSATransition = new FSATransition(state, state2, string);
        return fSATransition;
    }

    public static String getExpressionBetweenStates(State state, State state2, Automaton automaton) {
        Transition[] transitionArray = automaton.getTransitionsFromStateToState(state, state2);
        FSATransition fSATransition = (FSATransition)transitionArray[0];
        return fSATransition.getLabel();
    }

    public static String getExpression(int n, int n2, int n3, Automaton automaton) {
        State state = automaton.getStateWithID(n);
        State state2 = automaton.getStateWithID(n2);
        State state3 = automaton.getStateWithID(n3);
        String string = FSAToRegularExpressionConverter.getExpressionBetweenStates(state, state2, automaton);
        String string2 = FSAToRegularExpressionConverter.getExpressionBetweenStates(state, state3, automaton);
        String string3 = FSAToRegularExpressionConverter.getExpressionBetweenStates(state3, state3, automaton);
        String string4 = FSAToRegularExpressionConverter.getExpressionBetweenStates(state3, state2, automaton);
        String string5 = FSAToRegularExpressionConverter.star(string3);
        String string6 = FSAToRegularExpressionConverter.concatenate(string2, string5);
        String string7 = FSAToRegularExpressionConverter.concatenate(string6, string4);
        String string8 = FSAToRegularExpressionConverter.or(string, string7);
        return string8;
    }

    public static String concatenate(String string, String string2) {
        if (string.equals(EMPTY) || string2.equals(EMPTY)) {
            return EMPTY;
        }
        if (string.equals(LAMBDA)) {
            return string2;
        }
        if (string2.equals(LAMBDA)) {
            return string;
        }
        if (Discretizer.or(string).length > 1) {
            string = FSAToRegularExpressionConverter.addParen(string);
        }
        if (Discretizer.or(string2).length > 1) {
            string2 = FSAToRegularExpressionConverter.addParen(string2);
        }
        return string + string2;
    }

    public static String star(String string) {
        if (string.equals(EMPTY) || string.equals(LAMBDA)) {
            return LAMBDA;
        }
        if (Discretizer.or(string).length > 1 || Discretizer.cat(string).length > 1) {
            string = FSAToRegularExpressionConverter.addParen(string);
        } else if (string.endsWith(KLEENE_STAR)) {
            return string;
        }
        return string + KLEENE_STAR;
    }

    public static String or(String string, String string2) {
        if (string.equals(EMPTY)) {
            return string2;
        }
        if (string2.equals(EMPTY)) {
            return string;
        }
        if (string.equals(LAMBDA) && string2.equals(LAMBDA)) {
            return LAMBDA;
        }
        if (string.equals(LAMBDA)) {
            string = LAMBDA_DISPLAY;
        }
        if (string2.equals(LAMBDA)) {
            string2 = LAMBDA_DISPLAY;
        }
        return string + OR + string2;
    }

    public static void removeState(State state, Transition[] transitionArray, Automaton automaton) {
        int n;
        Transition[] transitionArray2 = automaton.getTransitions();
        for (n = 0; n < transitionArray2.length; ++n) {
            automaton.removeTransition(transitionArray2[n]);
        }
        automaton.removeState(state);
        for (n = 0; n < transitionArray.length; ++n) {
            automaton.addTransition(transitionArray[n]);
        }
    }

    public static Transition[] getTransitionsForRemoveState(State state, Automaton automaton) {
        if (!FSAToRegularExpressionConverter.isRemovable(state, automaton)) {
            return null;
        }
        ArrayList<Transition> arrayList = new ArrayList<Transition>();
        int n = state.getID();
        State[] stateArray = automaton.getStates();
        for (int i = 0; i < stateArray.length; ++i) {
            int n2 = stateArray[i].getID();
            if (n2 == n) continue;
            for (int j = 0; j < stateArray.length; ++j) {
                int n3 = stateArray[j].getID();
                if (n3 == n) continue;
                String string = FSAToRegularExpressionConverter.getExpression(n2, n3, n, automaton);
                arrayList.add(FSAToRegularExpressionConverter.getTransitionForExpression(n2, n3, string, automaton));
            }
        }
        return arrayList.toArray(new Transition[0]);
    }

    public static FSATransition addTransitionOnEmptySet(State state, State state2, Automaton automaton) {
        FSATransition fSATransition = new FSATransition(state, state2, EMPTY);
        automaton.addTransition(fSATransition);
        return fSATransition;
    }

    public static FSATransition combineToSingleTransition(State state, State state2, Transition[] transitionArray, Automaton automaton) {
        String string = ((FSATransition)transitionArray[0]).getDescription();
        automaton.removeTransition(transitionArray[0]);
        for (int i = 1; i < transitionArray.length; ++i) {
            string = FSAToRegularExpressionConverter.or(string, ((FSATransition)transitionArray[i]).getDescription());
            automaton.removeTransition(transitionArray[i]);
        }
        FSATransition fSATransition = new FSATransition(state, state2, string);
        automaton.addTransition(fSATransition);
        return fSATransition;
    }

    public static void getSingleFinalState(Automaton automaton) {
        StatePlacer statePlacer = new StatePlacer();
        State state = automaton.createState(statePlacer.getPointForState(automaton));
        State[] stateArray = automaton.getFinalStates();
        for (int i = 0; i < stateArray.length; ++i) {
            State state2 = stateArray[i];
            automaton.addTransition(new FSATransition(state2, state, LAMBDA));
            automaton.removeFinalState(state2);
        }
        automaton.addFinalState(state);
    }

    public static void convertToSimpleAutomaton(Automaton automaton) {
        if (!FSAToRegularExpressionConverter.isConvertable(automaton)) {
            FSAToRegularExpressionConverter.getSingleFinalState(automaton);
        }
        State[] stateArray = automaton.getStates();
        for (int i = 0; i < stateArray.length; ++i) {
            for (int j = 0; j < stateArray.length; ++j) {
                Transition[] transitionArray = automaton.getTransitionsFromStateToState(stateArray[i], stateArray[j]);
                if (transitionArray.length == 0) {
                    FSAToRegularExpressionConverter.addTransitionOnEmptySet(stateArray[i], stateArray[j], automaton);
                }
                if (transitionArray.length <= 1) continue;
                FSAToRegularExpressionConverter.combineToSingleTransition(stateArray[i], stateArray[j], transitionArray, automaton);
            }
        }
    }

    public static void convertToGTG(Automaton automaton) {
        State[] stateArray = automaton.getFinalStates();
        State state = stateArray[0];
        State state2 = automaton.getInitialState();
        State[] stateArray2 = automaton.getStates();
        for (int i = 0; i < stateArray2.length; ++i) {
            State state3 = stateArray2[i];
            if (state3 == state || state3 == state2) continue;
            Transition[] transitionArray = FSAToRegularExpressionConverter.getTransitionsForRemoveState(state3, automaton);
            FSAToRegularExpressionConverter.removeState(state3, transitionArray, automaton);
        }
    }

    public static boolean isSingleCharacter(String string) {
        if (string.length() != 1) {
            return false;
        }
        char c = string.charAt(0);
        return Character.isLetter(c);
    }

    public static boolean needsParens(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != '+') continue;
            return true;
        }
        return false;
    }

    public static String addParen(String string) {
        return LEFT_PAREN + string + RIGHT_PAREN;
    }

    public static String getExp(String string) {
        if (string.equals(LAMBDA)) {
            return "lambda";
        }
        if (string.equals(EMPTY)) {
            return "empty";
        }
        return string;
    }

    public static String getFinalExpression(String string, String string2, String string3, String string4) {
        String string5 = FSAToRegularExpressionConverter.concatenate(FSAToRegularExpressionConverter.star(string), FSAToRegularExpressionConverter.concatenate(string2, FSAToRegularExpressionConverter.concatenate(FSAToRegularExpressionConverter.star(string3), string4)));
        String string6 = FSAToRegularExpressionConverter.concatenate(FSAToRegularExpressionConverter.star(string), FSAToRegularExpressionConverter.concatenate(string2, FSAToRegularExpressionConverter.star(string3)));
        String string7 = FSAToRegularExpressionConverter.concatenate(FSAToRegularExpressionConverter.star(string5), string6);
        return string7;
    }

    public static String getII(Automaton automaton) {
        State state = automaton.getInitialState();
        return FSAToRegularExpressionConverter.getExpressionBetweenStates(state, state, automaton);
    }

    public static String getIJ(Automaton automaton) {
        State state = automaton.getInitialState();
        State[] stateArray = automaton.getFinalStates();
        State state2 = stateArray[0];
        return FSAToRegularExpressionConverter.getExpressionBetweenStates(state, state2, automaton);
    }

    public static String getJJ(Automaton automaton) {
        State[] stateArray = automaton.getFinalStates();
        State state = stateArray[0];
        return FSAToRegularExpressionConverter.getExpressionBetweenStates(state, state, automaton);
    }

    public static String getJI(Automaton automaton) {
        State state = automaton.getInitialState();
        State[] stateArray = automaton.getFinalStates();
        State state2 = stateArray[0];
        return FSAToRegularExpressionConverter.getExpressionBetweenStates(state2, state, automaton);
    }

    public static String getExpressionFromGTG(Automaton automaton) {
        String string = FSAToRegularExpressionConverter.getII(automaton);
        String string2 = FSAToRegularExpressionConverter.getIJ(automaton);
        String string3 = FSAToRegularExpressionConverter.getJJ(automaton);
        String string4 = FSAToRegularExpressionConverter.getJI(automaton);
        return FSAToRegularExpressionConverter.getFinalExpression(string, string2, string3, string4);
    }

    public static String convertToRegularExpression(Automaton automaton) {
        if (!FSAToRegularExpressionConverter.isConvertable(automaton)) {
            return null;
        }
        FSAToRegularExpressionConverter.convertToGTG(automaton);
        return FSAToRegularExpressionConverter.getExpressionFromGTG(automaton);
    }
}

