/*
 * Decompiled with CFR 0.152.
 */
package automata;

import automata.Automaton;
import automata.AutomatonSimulator;
import automata.fsa.FSAStepWithClosureSimulator;
import automata.fsa.FiniteStateAutomaton;
import automata.mealy.MealyMachine;
import automata.mealy.MealyStepByStateSimulator;
import automata.mealy.MooreMachine;
import automata.mealy.MooreStepByStateSimulator;
import automata.pda.PDAStepWithClosureSimulator;
import automata.pda.PushdownAutomaton;
import automata.turing.TMSimulator;
import automata.turing.TuringMachine;

public class SimulatorFactory {
    public static AutomatonSimulator getSimulator(Automaton automaton) {
        if (automaton instanceof FiniteStateAutomaton) {
            return new FSAStepWithClosureSimulator(automaton);
        }
        if (automaton instanceof PushdownAutomaton) {
            return new PDAStepWithClosureSimulator(automaton);
        }
        if (automaton instanceof TuringMachine) {
            return new TMSimulator(automaton);
        }
        if (automaton instanceof MooreMachine) {
            return new MooreStepByStateSimulator(automaton);
        }
        if (automaton instanceof MealyMachine) {
            return new MealyStepByStateSimulator(automaton);
        }
        return null;
    }
}

