/*
 * Decompiled with CFR 0.152.
 */
package automata;

import gui.editor.DeleteTool;
import gui.editor.EditorPane;
import gui.editor.Tool;
import gui.environment.AutomatonEnvironment;
import gui.viewer.AutomatonPane;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JTextArea;

public class Note
extends JTextArea {
    private Point myAutoPoint = null;
    public boolean moving = false;
    protected Point initialPointState;
    protected Point initialPointClick;
    protected AutomatonPane myView;
    public Point myViewPoint = new Point(0, 0);

    public Note(Point point, String string) {
        this.setLocationManually(point);
        this.setText(string);
    }

    public Note(String string) {
        this.setText(string);
    }

    public Note(Point point) {
        this.setLocationManually(point);
    }

    public void setView(AutomatonPane automatonPane) {
        this.myView = automatonPane;
    }

    public void initializeForView(AutomatonPane automatonPane) {
        this.myView = automatonPane;
        this.setLocationManually(this.myAutoPoint);
        this.setDisabledTextColor(Color.BLACK);
        this.setBackground(new Color(255, 255, 150));
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    return;
                }
                if (!((Note)mouseEvent.getSource()).isEditable()) {
                    int n = mouseEvent.getPoint().x - Note.this.initialPointClick.x;
                    int n2 = mouseEvent.getPoint().y - Note.this.initialPointClick.y;
                    int n3 = Note.this.initialPointState.x + n;
                    int n4 = Note.this.initialPointState.y + n2;
                    ((Note)mouseEvent.getSource()).setLocationManually(new Point(n3, n4));
                    Note.this.initialPointState = new Point(((Note)mouseEvent.getSource()).getAutoPoint());
                }
                Note.this.myView.repaint();
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
            }
        });
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (Note.this.myView.getDrawer().getAutomaton().getEnvironmentFrame() != null) {
                    ((AutomatonEnvironment)Note.this.myView.getDrawer().getAutomaton().getEnvironmentFrame().getEnvironment()).saveStatus();
                }
                ((Note)mouseEvent.getComponent()).setEnabled(true);
                ((Note)mouseEvent.getComponent()).setEditable(true);
                ((Note)mouseEvent.getComponent()).setCaretColor(null);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (Note.this.myView.getDrawer().getAutomaton().getEnvironmentFrame() != null) {
                    ((AutomatonEnvironment)Note.this.myView.getDrawer().getAutomaton().getEnvironmentFrame().getEnvironment()).saveStatus();
                    ((AutomatonEnvironment)Note.this.myView.getDrawer().getAutomaton().getEnvironmentFrame().getEnvironment()).setDirty();
                }
                Note.this.initialPointState = new Point(((Note)mouseEvent.getSource()).getAutoPoint());
                Note.this.initialPointClick = new Point(mouseEvent.getPoint().x, mouseEvent.getPoint().y);
                EditorPane editorPane = Note.this.myView.getCreator();
                Tool tool = editorPane.getToolBar().getCurrentTool();
                if (tool instanceof DeleteTool) {
                    Note.this.myView.remove((Note)mouseEvent.getSource());
                    Note.this.myView.getDrawer().getAutomaton().deleteNote((Note)mouseEvent.getSource());
                    Note.this.myView.repaint();
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
        this.myView.add(this);
        this.setEnabled(true);
        this.setEditable(true);
        this.setCaretColor(null);
        this.setSelectionStart(0);
        this.setSelectionEnd(this.getColumnWidth());
        this.requestFocus();
    }

    public Point getAutoPoint() {
        return this.myAutoPoint;
    }

    public AutomatonPane getView() {
        return this.myView;
    }

    public void setLocationManually(Point point) {
        this.moving = true;
        this.myAutoPoint = point;
        if (this.myView != null) {
            this.setLocation(this.myView.transformFromAutomatonToView(point));
        }
    }

    @Override
    public void setLocation(Point point) {
        if (this.moving && this.myView != null) {
            this.myViewPoint = point;
            super.setLocation(point);
        }
    }

    @Override
    public void setLocation(int n, int n2) {
        if (this.moving) {
            super.setLocation(n, n2);
        }
        this.moving = false;
    }

    public void updateView() {
        this.setLocationManually(this.myAutoPoint);
    }

    public int specialHash() {
        return this.myAutoPoint == null ? -1 : this.myAutoPoint.hashCode() + this.getText().hashCode();
    }
}

