/*
 * Decompiled with CFR 0.152.
 */
package regular;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.util.HashSet;
import java.util.Set;
import regular.ExpressionChangeEvent;
import regular.ExpressionChangeListener;

public class RegularExpression
implements Serializable {
    private String string;
    private transient Set listeners = new HashSet();
    private Reference reference = null;

    public RegularExpression() {
        this("");
    }

    public RegularExpression(String string) {
        this.change(string);
    }

    public RegularExpression(RegularExpression regularExpression) {
        this(regularExpression.asString());
    }

    public String asString() {
        try {
            String string = (String)this.reference.get();
            if (string.equals(this.string)) {
                return this.string;
            }
            this.string = string;
            this.reference = null;
            this.distributeChangeEvent(string);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return this.string;
    }

    public String toString() {
        return this.asString();
    }

    private boolean areParenthesesBalanced(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '(') {
                ++n;
            } else if (string.charAt(i) == ')') {
                --n;
            }
            if (n >= 0) continue;
            return false;
        }
        return n == 0;
    }

    public void change(String string) {
        try {
            if (this.string.equals(string)) {
                return;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        String string2 = this.string;
        this.string = string;
        this.distributeChangeEvent(string2);
    }

    public void change(Reference reference) {
        this.reference = reference;
    }

    public String asCheckedString() {
        this.string = this.asString();
        if (this.string.length() == 0) {
            throw new UnsupportedOperationException("The expression must be nonempty.");
        }
        if (!this.areParenthesesBalanced(this.string)) {
            throw new UnsupportedOperationException("The parentheses are unbalanced!");
        }
        switch (this.string.charAt(0)) {
            case ')': 
            case '*': 
            case '+': {
                throw new UnsupportedOperationException("Operators are poorly formatted.");
            }
        }
        block8: for (int i = 1; i < this.string.length(); ++i) {
            char c = this.string.charAt(i);
            char c2 = this.string.charAt(i - 1);
            switch (c) {
                case '+': {
                    if (i == this.string.length() - 1) {
                        throw new UnsupportedOperationException("Operators are poorly formatted.");
                    }
                }
                case ')': 
                case '*': {
                    if (c2 != '(' && c2 != '+') continue block8;
                    throw new UnsupportedOperationException("Operators are poorly formatted.");
                }
                case '!': {
                    if (c2 != '(' && c2 != '+') {
                        throw new UnsupportedOperationException("Lambda character must not cat with anything else.");
                    }
                    if (i == this.string.length() - 1 || (c2 = this.string.charAt(i + 1)) == ')' || c2 == '+' || c2 == '*') continue block8;
                    throw new UnsupportedOperationException("Lambda character must not cat with anything else.");
                }
            }
        }
        return this.string;
    }

    public void addExpressionListener(ExpressionChangeListener expressionChangeListener) {
        this.listeners.add(expressionChangeListener);
    }

    public void removeExpressionListener(ExpressionChangeListener expressionChangeListener) {
        this.listeners.remove(expressionChangeListener);
    }

    protected void distributeChangeEvent(String string) {
        ExpressionChangeEvent expressionChangeEvent = new ExpressionChangeEvent(this, string);
        for (ExpressionChangeListener expressionChangeListener : this.listeners) {
            expressionChangeListener.expressionChanged(expressionChangeEvent);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.asString();
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.listeners = new HashSet();
    }
}

