/*
 * Decompiled with CFR 0.152.
 */
package pumping.reg;

import pumping.RegularPumpingLemma;

public class BkABnBAn
extends RegularPumpingLemma {
    @Override
    public String getHTMLTitle() {
        return "<i>b<sup>k</sup>(ab)<sup>n</sup>(ba)<sup>n</sup></i> : <i>k</i> " + GREATER_OR_EQ + " 4" + ", <i>n</i> = 1,2...";
    }

    @Override
    public String getTitle() {
        return "b^k (ab)^n (ba)^n: k>=4, n = 1,2,...";
    }

    @Override
    public void setDescription() {
        this.partitionIsValid = false;
        this.explanation = "For any <i>m</i> value, a possible value for <i>w</i> is \"b<sup>4</sup>(ab)<sup><i>m</i>/2</sup>(ba)<sup><i>m</i>/2</sup>\".  No possible <i>y</i> value among the \"b<sup>4</sup>(ab)<sup><i>m</i>/2</sup>\" segment will work, so the language is not regular.";
    }

    @Override
    public void chooseI() {
        this.i = 0;
    }

    @Override
    public void chooseDecomposition() {
        int n = this.w.indexOf(97);
        int n2 = n + (this.w.length() - n) / 2 - 2;
        if (n > 4) {
            this.setDecomposition(new int[]{0, 1});
        } else if (n2 + 4 <= this.m) {
            this.setDecomposition(new int[]{n2, 4});
        } else {
            super.chooseDecomposition();
        }
    }

    @Override
    protected void chooseW() {
        int n = this.m / 2;
        this.w = "bbbb" + BkABnBAn.pumpString("ab", n) + BkABnBAn.pumpString("ba", n);
    }

    @Override
    protected void setRange() {
        this.myRange = new int[]{4, 15};
    }

    @Override
    public boolean isInLang(String string) {
        int n = string.indexOf("a");
        if (n < 4) {
            return false;
        }
        String string2 = string.substring(n);
        if (!string2.startsWith("ab")) {
            return false;
        }
        int n2 = 0;
        while (string2.startsWith("ab")) {
            string2 = string2.substring(2);
            ++n2;
        }
        while (string2.startsWith("ba")) {
            string2 = string2.substring(2);
            --n2;
        }
        return n2 == 0 && string2.length() == 0;
    }
}

