/*
 * Decompiled with CFR 0.152.
 */
package pumping.reg;

import pumping.LemmaMath;
import pumping.RegularPumpingLemma;

public class B5W
extends RegularPumpingLemma {
    @Override
    public String getTitle() {
        return "b^5w: w element_of {ab}* : 2na(w) = 3nb(w)";
    }

    @Override
    public String getHTMLTitle() {
        return "<i>b<sup>5</sup>w</i> : <i>w</i> " + ELEMENT_OF + " " + AB_STAR + ", 2<i>n<sub>a</sub></i> (<i>w</i>) = " + " 3<i>n<sub>b</sub></i> (<i>w</i>)";
    }

    @Override
    public void setDescription() {
        this.partitionIsValid = false;
        this.explanation = "For any <i>m</i> value " + GREATER_OR_EQ + " 6, a possible value for <i>w</i> is " + "\"b<sup>5</sup>b<sup>2(<i>m</i>-5)</sup>a<sup>3(<i>m</i>-5)</sup>\".  The <i>y</i> value thus would " + "be a multiple of \"b\".  For any <i>i</i> " + NOT_EQUAL + " 1, 2n<sub>a</sub>('w') " + NOT_EQUAL + " 3n<sub>b</sub>('w') or n<sub>b</sub> in the whole string" + LESS_THAN + " 5, giving a string which is " + "not in the language.  Thus, the language is not regular.";
    }

    @Override
    public void chooseI() {
        this.i = LemmaMath.flipCoin();
    }

    @Override
    protected void chooseW() {
        int n = this.m - 5;
        this.w = "bbbbb" + B5W.pumpString("b", 2 * n) + B5W.pumpString("a", 3 * n);
    }

    @Override
    public void chooseDecomposition() {
        int n = 5;
        int n2 = 0;
        while (n2 < 3) {
            if (this.w.charAt(n) == 'a') {
                ++n2;
            }
            ++n;
        }
        this.setDecomposition(new int[]{Math.min(n - 5, this.m - 5), 5});
    }

    @Override
    protected void setRange() {
        this.myRange = new int[]{6, 10};
    }

    @Override
    public boolean isInLang(String string) {
        int n;
        char[] cArray = new char[]{'a', 'b'};
        if (LemmaMath.otherCharactersFound(string, cArray)) {
            return false;
        }
        if (!string.startsWith("bbbbb")) {
            return false;
        }
        String string2 = string.substring(5);
        int n2 = LemmaMath.countInstances(string2, 'a');
        return 2 * n2 == 3 * (n = LemmaMath.countInstances(string2, 'b'));
    }
}

