/*
 * Decompiled with CFR 0.152.
 */
package pumping.reg;

import pumping.LemmaMath;
import pumping.RegularPumpingLemma;

public class AB2n
extends RegularPumpingLemma {
    @Override
    public String getTitle() {
        return "(ab)^2n : n = 1,2,...";
    }

    @Override
    public String getHTMLTitle() {
        return "(<i>ab</i>)<i><sup>2n</sup></i> : <i>n</i> = 1,2,...";
    }

    @Override
    public void setDescription() {
        this.partitionIsValid = true;
        this.explanation = "Because this is a regular language, a valid decomposition exists.  As long as <i>m</i> " + GREATER_OR_EQ + " 4, then if <i>y</i> = \"abab\" (or \"baba\" if <i>m</i>" + GREATER_OR_EQ + "5), the decomposition can be " + "pumped for any <i>i</i> value.";
    }

    @Override
    protected void setRange() {
        this.myRange = new int[]{4, 10};
    }

    @Override
    public void chooseI() {
        this.i = LemmaMath.flipCoin();
    }

    @Override
    protected void chooseW() {
        this.w = this.m % 2 == 0 ? AB2n.pumpString("ab", this.m) : AB2n.pumpString("ab", this.m + 1);
    }

    @Override
    public void chooseDecomposition() {
        this.setDecomposition(new int[]{0, 4});
    }

    @Override
    public boolean isInLang(String string) {
        String string2 = string;
        int n = 0;
        while (string2.startsWith("ab")) {
            string2 = string2.substring(2);
            ++n;
        }
        return n > 0 && n % 2 == 0 && string2.length() == 0;
    }
}

