/*
 * Decompiled with CFR 0.152.
 */
package pumping.cf;

import pumping.Case;
import pumping.ContextFreePumpingLemma;
import pumping.LemmaMath;

public class AnBjAnBj
extends ContextFreePumpingLemma {
    @Override
    public String getTitle() {
        return "a^n b^j a^n b^j : n >= 0, j >= 0";
    }

    @Override
    public String getHTMLTitle() {
        return "<i>a<sup>n</sup>b<sup>j</sup>a<sup>n</sup>b<sup>j</sup></i> : <i>n</i> " + GREATER_OR_EQ + " 0, <i>j</i> " + GREATER_OR_EQ + " 0";
    }

    @Override
    public void setDescription() {
        this.partitionIsValid = false;
        this.explanation = "For any <i>m</i> value, a possible value for <i>w</i> is \"a<sup><i>m</i></sup>b<sup><i>m</i></sup>a<sup><i>m</i></sup>b<sup><i>m</i></sup>\".  To be in the language with this example, <i>v</i> & <i>y</i> together cannot possess identical letters that are from separate blocks of alike letters (ex: <i>v</i> has \"b\"s from the first set of \"b\"s, while <i>y</i> has \"b\"s from the second set of \"b\"s).  Because of this, any increase or decrease in \"a\"s or \"b\"s will not be matched by any change in the other blocks of similar letters, resulting in an inequality that prevents the decomposition from working.  Thus, this language is not context-free.";
    }

    @Override
    protected void chooseW() {
        this.w = AnBjAnBj.pumpString("a", this.getM()) + AnBjAnBj.pumpString("b", this.getM()) + AnBjAnBj.pumpString("a", this.getM()) + AnBjAnBj.pumpString("b", this.getM());
    }

    @Override
    public void chooseDecomposition() {
        int n = this.w.length() / 2 - 1;
        if (n > this.m - 2) {
            n = this.m - 2;
        }
        if (this.w.indexOf(97) > -1) {
            this.setDecomposition(new int[]{0, 1, n, 1});
        } else {
            this.setDecomposition(new int[]{this.w.indexOf(98), 1, n, 1});
        }
    }

    @Override
    public void chooseI() {
        this.i = 0;
    }

    @Override
    protected void setRange() {
        this.myRange = new int[]{3, 5};
    }

    @Override
    protected void addCases() {
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.indexOf("a") > -1 && string.indexOf("b") == -1 && string2.indexOf("a") > -1 && string2.indexOf("b") == -1;
            }

            @Override
            public String description() {
                return "v is a string of \"a\"s and y is a string of \"a\"s";
            }

            @Override
            public int[] getPreset() {
                return new int[]{0, 1, 0, 1};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.indexOf("a") > -1 && string.indexOf("b") == -1 && string2.indexOf("a") > -1 && string2.indexOf("b") > -1 && string2.indexOf("a") < string2.indexOf("b");
            }

            @Override
            public String description() {
                return "v is a string of \"a\"s and y is a string of \"a\"s followed by \"b\"s";
            }

            @Override
            public int[] getPreset() {
                return new int[]{1, 1, 0, AnBjAnBj.this.m - 1};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.indexOf("a") > -1 && string.indexOf("b") == -1 && string2.indexOf("a") == -1 && string2.indexOf("b") > -1;
            }

            @Override
            public String description() {
                return "v is a string of \"a\"s and y is a string of \"b\"s";
            }

            @Override
            public int[] getPreset() {
                return new int[]{AnBjAnBj.this.m - 1, 1, 0, 1};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.indexOf("a") > -1 && string.indexOf("b") > -1 && string.indexOf("a") < string.indexOf("b") && string2.indexOf("a") == -1 && string2.indexOf("b") > -1;
            }

            @Override
            public String description() {
                return "v is a string of \"a\"s followed by \"b\"s and y is a string of \"b\"s";
            }

            @Override
            public int[] getPreset() {
                return new int[]{AnBjAnBj.this.m - 1, 2, 0, 1};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.indexOf("a") == -1 && string.indexOf("b") > -1 && string2.indexOf("a") == -1 && string2.indexOf("b") > -1;
            }

            @Override
            public String description() {
                return "v is a string of \"b\"s and y is a string of \"b\"s";
            }

            @Override
            public int[] getPreset() {
                return new int[]{AnBjAnBj.this.m, 1, 0, 1};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.indexOf("a") == -1 && string.indexOf("b") > -1 && string2.indexOf("a") > -1 && string2.indexOf("b") > -1 && string2.indexOf("a") > string2.indexOf("b");
            }

            @Override
            public String description() {
                return "v is a string of \"b\"s and y is a string of \"b\"s followed by \"a\"s";
            }

            @Override
            public int[] getPreset() {
                return new int[]{2 * AnBjAnBj.this.m - 2, 1, 0, 2};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.indexOf("a") == -1 && string.indexOf("b") > -1 && string2.indexOf("a") > -1 && string2.indexOf("b") == -1;
            }

            @Override
            public String description() {
                return "v is a string of \"b\"s and y is a string of \"a\"s";
            }

            @Override
            public int[] getPreset() {
                return new int[]{2 * AnBjAnBj.this.m - 1, 1, 0, 1};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.indexOf("a") > -1 && string.indexOf("b") > -1 && string.indexOf("a") > string.indexOf("b") && string2.indexOf("a") > -1 && string2.indexOf("b") > -1;
            }

            @Override
            public String description() {
                return "v is a string of \"b\"s followed by \"a\"s and y is a string of \"a\"s";
            }

            @Override
            public int[] getPreset() {
                return new int[]{2 * AnBjAnBj.this.m - 1, 2, 0, 1};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.length() == 0 && string2.length() > 0;
            }

            @Override
            public String description() {
                return "v is an empty string and y is a non-empty string";
            }

            @Override
            public int[] getPreset() {
                return new int[]{2 * AnBjAnBj.this.m, 0, 1, 1};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.length() > 0 && string2.length() == 0;
            }

            @Override
            public String description() {
                return "v is a non-empty string and y is an empty string";
            }

            @Override
            public int[] getPreset() {
                return new int[]{2 * AnBjAnBj.this.m, 1, 0, 0};
            }
        });
    }

    @Override
    public boolean isInLang(String string) {
        String string2;
        int n = string.length() / 2;
        String string3 = string.substring(0, n);
        if (!string3.equals(string2 = string.substring(n))) {
            return false;
        }
        char[] cArray = new char[]{'a', 'b'};
        return !LemmaMath.isMixture(string3, cArray) && !LemmaMath.isMixture(string2, cArray);
    }
}

