/*
 * Decompiled with CFR 0.152.
 */
package pumping;

import java.io.Serializable;
import java.util.ArrayList;
import pumping.Case;
import pumping.LemmaMath;

public abstract class PumpingLemma
implements Serializable {
    public static final String COMPUTER = "Computer";
    public static final String HUMAN = "Human";
    protected static String AB_STAR = "{<i>a</i>, <i>b</i>}*";
    protected static String NOT_EQUAL = "&#8800;";
    protected static String ELEMENT_OF = "&#8712;";
    protected static String GREATER_OR_EQ = "&#8805;";
    protected static String GREATER_THAN = "&#62;";
    protected static String LESS_THAN = "&#60;";
    protected static String LESS_OR_EQ = "&#8804;";
    protected boolean partitionIsValid;
    protected String explanation;
    protected String firstPlayer;
    protected int m;
    protected String w;
    protected int i;
    protected ArrayList myAllCases;
    protected ArrayList myDoneCases = new ArrayList();
    protected ArrayList myAttempts;
    protected int[] myRange;
    protected int[] myDecomposition;

    public PumpingLemma() {
        this.myAllCases = new ArrayList();
        this.myAttempts = new ArrayList();
        this.setRange();
        this.setDescription();
        this.reset();
        this.addCases();
    }

    protected static String pumpString(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = n; i > 0; --i) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public String getFirstPlayer() {
        return this.firstPlayer;
    }

    public int getM() {
        return this.m;
    }

    public String getW() {
        return this.w;
    }

    public int[] getDecomposition() {
        return this.myDecomposition;
    }

    public abstract String getDecompositionAsString();

    public int getI() {
        return this.i;
    }

    public ArrayList getAttempts() {
        return this.myAttempts;
    }

    public boolean getPartitionValidity() {
        return this.partitionIsValid;
    }

    public String getExplanation() {
        return this.explanation;
    }

    public abstract String getTitle();

    public abstract String getHTMLTitle();

    public int[] getRange() {
        return this.myRange;
    }

    protected abstract void setRange();

    public void setFirstPlayer(String string) {
        this.firstPlayer = string;
    }

    protected abstract void setDescription();

    public void setM(int n) {
        this.reset();
        this.m = n;
        this.chooseW();
    }

    public void setW(String string) {
        this.w = string;
    }

    public abstract boolean setDecomposition(int[] var1, int var2);

    public abstract boolean setDecomposition(int[] var1);

    public void setI(int n) {
        this.i = n;
    }

    public void addAttempt(String string) {
        this.myAttempts.add(string);
    }

    public void clearAttempts() {
        this.myAttempts.clear();
    }

    public abstract void reset();

    public void chooseM() {
        this.m = LemmaMath.fetchRandInt(this.myRange[0], this.myRange[1]);
    }

    protected abstract void chooseW();

    public abstract void chooseDecomposition();

    public abstract void chooseI();

    public abstract String createPumpedString();

    public int numCasesTotal() {
        return this.myAllCases.size();
    }

    public void doAll() {
        for (int i = 0; i < this.myAllCases.size(); ++i) {
            if (this.myDoneCases.contains(this.myAllCases.get(i))) continue;
            this.myDoneCases.add(this.myAllCases.get(i));
        }
    }

    public void clearDoneCases() {
        this.myDoneCases.clear();
        for (int i = 0; i < this.myAllCases.size(); ++i) {
            ((Case)this.myAllCases.get(i)).reset();
        }
    }

    public void clearCase(int n) {
        ((Case)this.myDoneCases.remove(n)).reset();
    }

    public Case getCase(int n) {
        return (Case)this.myDoneCases.get(n);
    }

    public abstract int addCase(int[] var1, int var2);

    public abstract boolean replaceCase(int[] var1, int var2, int var3);

    public ArrayList getDoneDescriptions() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.myDoneCases.size(); ++i) {
            arrayList.add(this.myDoneCases.get(i).toString());
        }
        return arrayList;
    }

    protected abstract void addCases();

    public ArrayList getDoneCases() {
        return this.myDoneCases;
    }

    public abstract boolean isInLang(String var1);
}

