/*
 * Decompiled with CFR 0.152.
 */
package gui.viewer;

import automata.Automaton;
import automata.State;
import automata.Transition;
import automata.event.AutomataStateEvent;
import gui.viewer.AutomatonDrawer;
import gui.viewer.StateDrawer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SelectionDrawer
extends AutomatonDrawer {
    private Set selected = new HashSet();
    private Set selectedTransitions = new HashSet();
    protected static final Color SELECTED_COLOR = StateDrawer.STATE_COLOR.darker().darker();
    private Set listeners = new HashSet();

    public SelectionDrawer(Automaton automaton) {
        super(automaton);
    }

    @Override
    protected void stateChange(AutomataStateEvent automataStateEvent) {
        if (automataStateEvent.isDelete()) {
            this.selected.remove(automataStateEvent.getState());
        }
        super.stateChange(automataStateEvent);
    }

    @Override
    public void drawState(Graphics graphics, State state) {
        if (this.selected.contains(state)) {
            this.getStateDrawer().drawState(graphics, this.getAutomaton(), state, state.getPoint(), SELECTED_COLOR);
            if (this.doesDrawStateLabels()) {
                this.getStateDrawer().drawStateLabel(graphics, state, state.getPoint(), StateDrawer.STATE_COLOR);
            }
        } else {
            super.drawState(graphics, state);
        }
    }

    @Override
    protected void drawTransitions(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        super.drawTransitions(graphics);
        for (Transition transition : this.selectedTransitions) {
            try {
                this.arrowForTransition(transition).drawHighlight(graphics2D);
            }
            catch (NullPointerException nullPointerException) {}
        }
    }

    public void addSelected(State state) {
        if (!this.selected.contains(state)) {
            this.selected.add(state);
            this.distributeChangeEvent();
        }
    }

    public void removeSelected(State state) {
        if (this.selected.contains(state)) {
            this.selected.remove(state);
            this.distributeChangeEvent();
        }
    }

    public int numberSelected() {
        return this.selected.size();
    }

    public State[] getSelected() {
        return this.selected.toArray(new State[0]);
    }

    public boolean isSelected(State state) {
        return this.selected.contains(state);
    }

    public void clearSelected() {
        if (this.selected.size() + this.selectedTransitions.size() > 0) {
            this.selected.clear();
            this.selectedTransitions.clear();
            this.distributeChangeEvent();
        }
    }

    protected Set selected() {
        return this.selected;
    }

    protected Set selectedTransitions() {
        return this.selectedTransitions;
    }

    public void addSelected(Transition transition) {
        if (transition.getFromState().getAutomaton() != this.getAutomaton()) {
            throw new IllegalArgumentException("Transition to select not in correct automaton!");
        }
        if (!this.selectedTransitions.contains(transition)) {
            this.selectedTransitions.add(transition);
            this.distributeChangeEvent();
        }
    }

    public void removeSelected(Transition transition) {
        if (this.selectedTransitions.contains(transition)) {
            this.selectedTransitions.remove(transition);
            this.distributeChangeEvent();
        }
    }

    public int numberSelectedTransitions() {
        return this.selectedTransitions.size();
    }

    public Transition[] getSelectedTransitions() {
        return this.selectedTransitions.toArray(new Transition[0]);
    }

    public boolean isSelected(Transition transition) {
        return this.selectedTransitions.contains(transition);
    }

    public void clearSelectedTransitions() {
        this.selectedTransitions.clear();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    protected void distributeChangeEvent() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((ChangeListener)iterator.next()).stateChanged(changeEvent);
        }
    }
}

