/*
 * Decompiled with CFR 0.152.
 */
package gui.viewer;

import automata.Transition;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class CurvedArrow {
    protected Point start;
    protected Point end;
    protected Point control;
    private Point high = new Point();
    protected float curvy;
    protected QuadCurve2D.Float curve;
    protected boolean needsRefresh = true;
    protected boolean startArrow = false;
    protected boolean endArrow = false;
    protected String label = "";
    private static double ARROW_ANGLE = 0.3141592653589793;
    private static double ARROW_LENGTH = 15.0;
    private static AffineTransform AFFINE_TURN_180;
    protected Rectangle2D bounds = new Rectangle(0, 0);
    protected AffineTransform affineToText;
    private static final int CHARS_PER_STEP = 4;
    protected static Graphics GRAPHICS;
    protected static FontMetrics METRICS;
    private static double HEIGHT;
    public static Color HIGHLIGHT_COLOR;
    public Transition myTransition;

    public CurvedArrow(int n, int n2, int n3, int n4, float f, Transition transition) {
        this.curve = new QuadCurve2D.Float();
        this.start = new Point();
        this.end = new Point();
        this.control = new Point();
        this.setStart(n, n2);
        this.setEnd(n3, n4);
        this.setCurvy(f);
        this.myTransition = transition;
        this.refreshCurve();
    }

    public CurvedArrow(Point point, Point point2, float f, Transition transition) {
        this.curve = new QuadCurve2D.Float();
        this.setStart(point);
        this.setEnd(point2);
        this.control = new Point();
        this.setCurvy(f);
        this.myTransition = transition;
        this.refreshCurve();
    }

    public void setStart(int n, int n2) {
        this.start.x = n;
        this.start.y = n2;
        this.needsRefresh = true;
    }

    public void setStart(Point point) {
        this.start = point;
        this.needsRefresh = true;
    }

    public void setEnd(int n, int n2) {
        this.end.x = n;
        this.end.y = n2;
        this.needsRefresh = true;
    }

    public void setEnd(Point point) {
        this.end = point;
        this.needsRefresh = true;
    }

    public void setCurvy(float f) {
        this.curvy = f;
        this.needsRefresh = true;
    }

    public void draw(Graphics2D graphics2D) {
        if (this.needsRefresh) {
            this.refreshCurve();
        }
        graphics2D.draw(this.curve);
        this.drawArrow(graphics2D, this.end, this.control);
        this.drawText(graphics2D);
    }

    public void drawControlPoint(Graphics2D graphics2D) {
        graphics2D.drawOval((int)this.curve.getCtrlX() - 5, (int)this.curve.getCtrlY() - 5, 10, 10);
    }

    public void drawHighlight(Graphics2D graphics2D) {
        if (this.needsRefresh) {
            this.refreshCurve();
        }
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        graphics2D2.setStroke(new BasicStroke(6.0f));
        graphics2D2.setColor(HIGHLIGHT_COLOR);
        graphics2D2.draw(this.curve);
        graphics2D2.transform(this.affineToText);
        graphics2D2.fill(this.bounds);
        graphics2D2.dispose();
    }

    public void drawText(Graphics2D graphics2D) {
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D2.transform(this.affineToText);
        FontMetrics fontMetrics = graphics2D2.getFontMetrics();
        this.bounds = fontMetrics.getStringBounds(this.getLabel(), graphics2D2);
        boolean bl = this.end.x < this.start.x;
        float f = (float)this.bounds.getWidth() / 2.0f;
        float f2 = this.curvy < 0.0f ^ bl ? (float)fontMetrics.getAscent() : (float)(-fontMetrics.getDescent());
        this.bounds.setRect(this.bounds.getX() - (double)f, this.bounds.getY() + (double)f2, this.bounds.getWidth(), this.bounds.getHeight());
        for (int i = 0; i < this.label.length(); i += 4) {
            String string = this.label.substring(i, Math.min(i + 4, this.label.length()));
            graphics2D2.drawString(string, -f, f2);
            f = (float)((double)f - fontMetrics.getStringBounds(string, graphics2D2).getWidth());
        }
        graphics2D2.dispose();
    }

    public void setLabel(String string) {
        this.label = string;
        this.bounds = METRICS.getStringBounds(this.getLabel(), GRAPHICS);
        boolean bl = this.end.x < this.start.x;
        float f = (float)this.bounds.getWidth() / 2.0f;
        float f2 = this.curvy < 0.0f ^ bl ? (float)METRICS.getAscent() : (float)(-METRICS.getDescent());
        this.bounds.setRect(this.bounds.getX() - (double)f, this.bounds.getY() + (double)f2, this.bounds.getWidth(), this.bounds.getHeight());
    }

    public String getLabel() {
        return this.label;
    }

    private void drawArrow(Graphics graphics, Point point, Point point2) {
        double d = Math.atan2(point2.x - point.x, point2.y - point.y);
        int n = (int)(Math.sin(d += ARROW_ANGLE) * ARROW_LENGTH) + point.x;
        int n2 = (int)(Math.cos(d) * ARROW_LENGTH) + point.y;
        graphics.drawLine(point.x, point.y, n, n2);
        n = (int)(Math.sin(d -= 2.0 * ARROW_ANGLE) * ARROW_LENGTH) + point.x;
        n2 = (int)(Math.cos(d) * ARROW_LENGTH) + point.y;
        graphics.drawLine(point.x, point.y, n, n2);
    }

    public void refreshCurve() {
        double d;
        this.needsRefresh = false;
        double d2 = this.end.x - this.start.x;
        double d3 = this.end.y - this.start.y;
        double d4 = (double)(this.start.x + this.end.x) / 2.0;
        double d5 = (double)(this.start.y + this.end.y) / 2.0;
        double d6 = Math.sqrt(d2 * d2 + d3 * d3);
        double d7 = d6 == 0.0 ? 0.0 : d2 / d6;
        double d8 = d = d6 == 0.0 ? 0.0 : d3 / d6;
        if (this.myTransition.getControl() == null) {
            this.control.x = (int)(d4 + (double)this.curvy * HEIGHT * d);
            this.control.y = (int)(d5 - (double)this.curvy * HEIGHT * d7);
            this.high.x = (int)(d4 + (double)this.curvy * HEIGHT * d / 2.0);
            this.high.y = (int)(d5 - (double)this.curvy * HEIGHT * d7 / 2.0);
        } else {
            this.control.x = this.myTransition.getControl().x;
            this.control.y = this.myTransition.getControl().y;
            double d9 = (double)this.control.x - d4;
            double d10 = d5 - (double)this.control.y;
            this.high.x = (int)(d4 + d9 / 2.0);
            this.high.y = (int)(d5 - d10 / 2.0);
        }
        this.curve.setCurve(this.start.x, this.start.y, this.control.x, this.control.y, this.end.x, this.end.y);
        this.affineToText = new AffineTransform();
        this.affineToText.translate(this.high.x, this.high.y);
        this.affineToText.rotate(Math.atan2(d3, d2));
        if (this.end.x < this.start.x) {
            this.affineToText.rotate(Math.PI);
        }
    }

    public Rectangle2D getBounds() {
        if (this.needsRefresh) {
            this.refreshCurve();
        }
        Rectangle rectangle = this.curve.getBounds();
        Area area = new Area(this.bounds);
        area.transform(this.affineToText);
        rectangle.add((Rectangle2D)area.getBounds());
        return rectangle;
    }

    public boolean isNear(Point point, int n) {
        if (this.needsRefresh) {
            this.refreshCurve();
        }
        try {
            if (this.bounds.contains(this.affineToText.inverseTransform(point, null))) {
                return true;
            }
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
        }
        catch (NullPointerException nullPointerException) {
            System.err.println(nullPointerException + " : " + this.bounds + " : " + this.affineToText);
            return false;
        }
        return this.intersects(point, n, this.curve);
    }

    private boolean intersects(Point point, int n, QuadCurve2D.Float float_) {
        if (!float_.intersects(point.x - n, point.y - n, n << 1, n << 1)) {
            return false;
        }
        if (float_.getFlatness() < (double)n) {
            return true;
        }
        QuadCurve2D.Float float_2 = new QuadCurve2D.Float();
        QuadCurve2D.Float float_3 = new QuadCurve2D.Float();
        float_.subdivide(float_2, float_3);
        return this.intersects(point, n, float_2) || this.intersects(point, n, float_3);
    }

    public QuadCurve2D getCurve() {
        return this.curve;
    }

    static {
        GRAPHICS = null;
        AFFINE_TURN_180 = new AffineTransform();
        AFFINE_TURN_180.rotate(Math.PI);
        BufferedImage bufferedImage = new BufferedImage(1, 1, 1);
        GRAPHICS = bufferedImage.getGraphics();
        METRICS = GRAPHICS.getFontMetrics();
        HEIGHT = 30.0;
        HIGHLIGHT_COLOR = new Color(255, 0, 0, 128);
    }
}

