/*
 * Decompiled with CFR 0.152.
 */
package gui.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class Trees {
    private Trees() {
    }

    public static TreeNode[] children(TreeNode treeNode) {
        TreeNode[] treeNodeArray = new TreeNode[treeNode.getChildCount()];
        if (!treeNode.isLeaf()) {
            int n = 0;
            Enumeration<? extends TreeNode> enumeration = treeNode.children();
            while (n < treeNodeArray.length) {
                treeNodeArray[n++] = enumeration.nextElement();
            }
        }
        return treeNodeArray;
    }

    public static int[] width(TreeModel treeModel) {
        int[] nArray = new int[Trees.depth(treeModel) + 1];
        Arrays.fill(nArray, 0);
        Trees.width((TreeNode)treeModel.getRoot(), 0, nArray);
        return nArray;
    }

    private static void width(TreeNode treeNode, int n, int[] nArray) {
        int n2 = n++;
        nArray[n2] = nArray[n2] + 1;
        if (treeNode.isLeaf()) {
            return;
        }
        TreeNode[] treeNodeArray = Trees.children(treeNode);
        for (int i = 0; i < treeNodeArray.length; ++i) {
            Trees.width(treeNodeArray[i], n, nArray);
        }
    }

    public static int depth(TreeModel treeModel) {
        return Trees.depth((TreeNode)treeModel.getRoot());
    }

    public static int depth(TreeNode treeNode) {
        TreeNode[] treeNodeArray = Trees.children(treeNode);
        int n = -1;
        for (int i = 0; i < treeNodeArray.length; ++i) {
            n = Math.max(n, Trees.depth(treeNodeArray[i]));
        }
        return n + 1;
    }

    public static TreeNode[] leaves(TreeModel treeModel) {
        return Trees.leaves((TreeNode)treeModel.getRoot());
    }

    public static TreeNode[] leaves(TreeNode treeNode) {
        TreeNode[] treeNodeArray = Trees.children(treeNode);
        if (treeNodeArray.length == 0) {
            return new TreeNode[]{treeNode};
        }
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        for (int i = 0; i < treeNodeArray.length; ++i) {
            TreeNode[] treeNodeArray2 = Trees.leaves(treeNodeArray[i]);
            for (int j = 0; j < treeNodeArray2.length; ++j) {
                arrayList.add(treeNodeArray2[j]);
            }
        }
        return arrayList.toArray(new TreeNode[0]);
    }
}

