/*
 * Decompiled with CFR 0.152.
 */
package gui.transform;

import java.awt.geom.Point2D;
import java.io.Serializable;

public class Matrix
implements Cloneable,
Serializable {
    public double[][] entry;
    private double[][] entry2 = new double[4][4];
    private static double XAXIS_ANGLE = Double.NaN;
    private static double YAXIS_ANGLE = Double.NaN;
    private static double ZAXIS_ANGLE = Double.NaN;
    private static Matrix XAXIS_TURN;
    private static Matrix YAXIS_TURN;
    private static Matrix ZAXIS_TURN;
    private static double[] DIRS;
    private static final Matrix TRANSLATE;
    private static final Matrix INVERSE;
    private static final double[] ORIGIN_REUSE;

    public Matrix() {
        this(1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
    }

    public Matrix(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12) {
        this.entry = new double[][]{{d, d2, d3, d4}, {d5, d6, d7, d8}, {d9, d10, d11, d12}, {0.0, 0.0, 0.0, 1.0}};
    }

    public Matrix(Matrix matrix) {
        this(matrix.entry[0][0], matrix.entry[0][1], matrix.entry[0][2], matrix.entry[0][3], matrix.entry[1][0], matrix.entry[1][1], matrix.entry[1][2], matrix.entry[1][3], matrix.entry[2][0], matrix.entry[2][1], matrix.entry[2][2], matrix.entry[2][3]);
    }

    public Object clone() {
        return new Matrix(this);
    }

    public final double valueAt(int n, int n2) {
        return this.entry[n][n2];
    }

    public final void premultiply(Matrix matrix) {
        this.entry[3][2] = 0.0;
        this.entry[3][1] = 0.0;
        this.entry2[3][0] = 0.0;
        this.entry2[3][3] = 1.0;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.entry2[i][j] = 0.0;
                for (int k = 0; k < 4; ++k) {
                    double[] dArray = this.entry2[i];
                    int n = j;
                    dArray[n] = dArray[n] + matrix.entry[i][k] * this.entry[k][j];
                }
            }
        }
        double[][] dArray = this.entry;
        this.entry = this.entry2;
        this.entry2 = dArray;
    }

    public final void postmultiply(Matrix matrix) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.entry2[i][j] = 0.0;
                for (int k = 0; k < 4; ++k) {
                    double[] dArray = this.entry2[i];
                    int n = j;
                    dArray[n] = dArray[n] + this.entry[i][k] * matrix.entry[k][j];
                }
            }
        }
        double[][] dArray = this.entry;
        this.entry = this.entry2;
        this.entry2 = dArray;
    }

    public final void pitch(double d) {
        if (XAXIS_ANGLE == -d) {
            XAXIS_ANGLE = d;
            Matrix.XAXIS_TURN.entry[1][2] = -Matrix.XAXIS_TURN.entry[1][2];
            Matrix.XAXIS_TURN.entry[2][1] = -Matrix.XAXIS_TURN.entry[2][1];
        } else if (XAXIS_ANGLE != d) {
            XAXIS_ANGLE = d;
            d = Math.toRadians(d);
            double d2 = Math.cos(d);
            double d3 = Math.sin(d);
            XAXIS_TURN = new Matrix(1.0, 0.0, 0.0, 0.0, 0.0, d2, -d3, 0.0, 0.0, d3, d2, 0.0);
        }
        this.premultiply(XAXIS_TURN);
    }

    public final void roll(double d) {
        if (YAXIS_ANGLE == -d) {
            YAXIS_ANGLE = d;
            Matrix.YAXIS_TURN.entry[0][2] = -Matrix.YAXIS_TURN.entry[0][2];
            Matrix.YAXIS_TURN.entry[2][0] = -Matrix.YAXIS_TURN.entry[2][0];
        } else if (YAXIS_ANGLE != d) {
            YAXIS_ANGLE = d;
            d = Math.toRadians(d);
            double d2 = Math.cos(d);
            double d3 = Math.sin(d);
            YAXIS_TURN = new Matrix(d2, 0.0, d3, 0.0, 0.0, 1.0, 0.0, 0.0, -d3, 0.0, d2, 0.0);
        }
        this.premultiply(YAXIS_TURN);
    }

    public final void yaw(double d) {
        if (ZAXIS_ANGLE == -d) {
            ZAXIS_ANGLE = d;
            Matrix.ZAXIS_TURN.entry[0][1] = -Matrix.ZAXIS_TURN.entry[0][1];
            Matrix.ZAXIS_TURN.entry[1][0] = -Matrix.ZAXIS_TURN.entry[1][0];
        } else if (ZAXIS_ANGLE != d) {
            ZAXIS_ANGLE = d;
            d = Math.toRadians(d);
            double d2 = Math.cos(d);
            double d3 = Math.sin(d);
            ZAXIS_TURN = new Matrix(d2, -d3, 0.0, 0.0, d3, d2, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
        }
        this.premultiply(ZAXIS_TURN);
    }

    public final void translate(double d, double d2, double d3) {
        if (DIRS[0] != d || DIRS[1] != d2 || DIRS[2] != d3) {
            double d4 = d;
            Matrix.TRANSLATE.entry[0][3] = d4;
            Matrix.DIRS[0] = d4;
            double d5 = d2;
            Matrix.TRANSLATE.entry[1][3] = d5;
            Matrix.DIRS[1] = d5;
            double d6 = d3;
            Matrix.TRANSLATE.entry[2][3] = d6;
            Matrix.DIRS[2] = d6;
        }
        this.premultiply(TRANSLATE);
    }

    public final Point2D origin(Point2D point2D) {
        if (point2D == null) {
            point2D = new Point2D.Double();
        }
        this.origin(ORIGIN_REUSE);
        point2D.setLocation(ORIGIN_REUSE[0], ORIGIN_REUSE[1]);
        return point2D;
    }

    public final double[] origin(double[] dArray) {
        int n;
        if (dArray == null) {
            dArray = new double[3];
        }
        for (n = 0; n < 3; ++n) {
            for (int i = 0; i < 3; ++i) {
                Matrix.INVERSE.entry[n][i] = this.entry[i][n];
            }
        }
        this.premultiply(INVERSE);
        for (n = 0; n < 3; ++n) {
            dArray[n] = this.entry[n][3];
        }
        double[][] dArray2 = this.entry;
        this.entry = this.entry2;
        this.entry2 = dArray2;
        return dArray;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        for (int i = 0; i < 4; ++i) {
            if (i != 0) {
                stringBuffer.append(";  ");
            }
            for (int j = 0; j < 4; ++j) {
                if (j != 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(' ');
                stringBuffer.append(this.entry[i][j]);
            }
        }
        stringBuffer.append(" )");
        return stringBuffer.toString();
    }

    public static final String arrayString(double[] dArray) {
        return "( " + dArray[0] + ", " + dArray[1] + ", " + dArray[2] + " )";
    }

    static {
        DIRS = new double[]{0.0, 0.0, 0.0};
        TRANSLATE = new Matrix();
        INVERSE = new Matrix();
        ORIGIN_REUSE = new double[3];
    }
}

