/*
 * Decompiled with CFR 0.152.
 */
package gui.sim;

import automata.Configuration;
import gui.sim.ConfigurationIcon;
import gui.sim.ConfigurationIconFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.LinkedList;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;

public class TraceWindow
extends JFrame {
    private static final int MAXHEIGHT = 400;

    public TraceWindow(Configuration configuration) {
        super("Traceback");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(TraceWindow.getPastPane(configuration));
        this.pack();
        if (this.getSize().height > 400) {
            this.setSize(this.getSize().width, 400);
        }
        this.setVisible(true);
    }

    public static JScrollPane getPastPane(Configuration configuration) {
        JScrollPane jScrollPane = new JScrollPane(new PastPane(configuration), 22, 31);
        jScrollPane.validate();
        if (jScrollPane.getSize().height > 400) {
            jScrollPane.setSize(jScrollPane.getSize().width, 400);
        }
        return jScrollPane;
    }

    public static PastPane getPastPaneNoScroll(Configuration configuration) {
        return new PastPane(configuration);
    }

    public static class PastPane
    extends JComponent {
        private Icon[] icons;
        private static final int ARROW_LENGTH = 20;

        public PastPane(Configuration configuration) {
            this.setConfiguration(configuration);
        }

        public void setConfiguration(Configuration configuration) {
            LinkedList<ConfigurationIcon> linkedList = new LinkedList<ConfigurationIcon>();
            int n = 0;
            int n2 = 0;
            while (configuration != null) {
                ConfigurationIcon configurationIcon = ConfigurationIconFactory.iconForConfiguration(configuration);
                n2 = Math.max(n2, configurationIcon.getIconWidth());
                n += configurationIcon.getIconHeight() + 20;
                linkedList.add(configurationIcon);
                configuration = configuration.getParent();
            }
            this.icons = linkedList.toArray(new Icon[0]);
            this.setPreferredSize(new Dimension(n2, n));
        }

        @Override
        public void paintComponent(Graphics graphics) {
            Rectangle rectangle = this.getVisibleRect();
            int n = 20 + this.icons[0].getIconHeight();
            int n2 = this.icons.length - 1 - rectangle.y / n;
            int n3 = this.icons.length - 1 - (rectangle.y + rectangle.height) / n;
            try {
                n3 = Math.max(n3, 0);
                graphics = graphics.create();
                graphics.translate(0, n * (this.icons.length - 1 - n2));
                for (int i = n2; i >= n3; --i) {
                    this.drawArrow(graphics);
                    this.drawIcon(graphics, this.icons[i]);
                }
                graphics.dispose();
            }
            catch (Throwable throwable) {
                System.err.println(throwable);
            }
        }

        public final void drawArrow(Graphics graphics) {
            int n = this.getWidth() >> 1;
            graphics.setColor(Color.black);
            graphics.drawLine(n, 0, n, 20);
            graphics.drawLine(n, 20, n - 10, 10);
            graphics.drawLine(n, 20, n + 10, 10);
            graphics.translate(0, 20);
        }

        public final void drawIcon(Graphics graphics, Icon icon) {
            icon.paintIcon(this, graphics, this.getWidth() - icon.getIconWidth() >> 1, 0);
            graphics.translate(0, icon.getIconHeight());
        }
    }
}

